/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalAuthenticationMethodAttributeDefinition
extends AbstractAttributeDefinition {
    private final Logger log = LoggerFactory.getLogger(PrincipalAuthenticationMethodAttributeDefinition.class);

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        String method = StringSupport.trimOrNull((String)resolutionContext.getPrincipalAuthenticationMethod());
        if (null == method) {
            this.log.info("{} null or empty method was returned", (Object)this.getLogPrefix());
            return null;
        }
        IdPAttribute attribute = new IdPAttribute(this.getId());
        attribute.setValues(Collections.singletonList(new StringAttributeValue(method)));
        return attribute;
    }
}

