/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.ScriptedIdPAttributeImpl;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedDataConnector
extends AbstractDataConnector {
    @Nonnull
    public static final String RESULTS_STRING = "connectorResults";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedDataConnector.class);
    @NonnullAfterInit
    private EvaluableScript script;
    @Nonnull
    private Function<AttributeResolutionContext, ProfileRequestContext> prcLookupStrategy = new ParentContextLookup();
    @Nullable
    private Object customObject;

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    @Nullable
    public void setCustomObject(Object object) {
        this.customObject = object;
    }

    @NonnullAfterInit
    public EvaluableScript getScript() {
        return this.script;
    }

    public void setScript(@Nonnull EvaluableScript definitionScript) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.script = (EvaluableScript)Constraint.isNotNull((Object)definitionScript, (String)"Attribute definition script cannot be null");
    }

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<AttributeResolutionContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.prcLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.script) {
            throw new ComponentInitializationException(this.getLogPrefix() + ": No script supplied");
        }
    }

    @Nonnull
    private ScriptContext getScriptContext(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        this.log.debug("{} adding to-be-populated attribute set {} to script context", (Object)this.getLogPrefix(), (Object)RESULTS_STRING);
        scriptContext.setAttribute(RESULTS_STRING, new HashSet(), 100);
        this.log.debug("{} adding current attribute resolution contexts to script context", (Object)this.getLogPrefix());
        scriptContext.setAttribute("resolutionContext", resolutionContext, 100);
        scriptContext.setAttribute("workContext", workContext, 100);
        scriptContext.setAttribute("profileContext", this.prcLookupStrategy.apply((Object)resolutionContext), 100);
        scriptContext.setAttribute("custom", this.getCustomObject(), 100);
        Map dependencyAttributes = PluginDependencySupport.getAllAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getDependencies());
        for (Map.Entry dependencyAttribute : dependencyAttributes.entrySet()) {
            this.log.debug("{} adding dependent attribute '{}' with the following values to the script context: {}", new Object[]{this.getLogPrefix(), dependencyAttribute.getKey(), dependencyAttribute.getValue()});
            IdPAttribute pseudoAttribute = new IdPAttribute((String)dependencyAttribute.getKey());
            pseudoAttribute.setValues((Collection)dependencyAttribute.getValue());
            scriptContext.setAttribute((String)dependencyAttribute.getKey(), new ScriptedIdPAttributeImpl(pseudoAttribute, this.getLogPrefix()), 100);
        }
        return scriptContext;
    }

    private void checkValues(IdPAttribute attribute) {
        if (null == attribute.getValues()) {
            this.log.info("{} Attribute '{}' has no values provided.", (Object)this.getLogPrefix(), (Object)attribute.getId());
            attribute.setValues(Collections.emptyList());
            return;
        }
        this.log.debug("{} Attribute '{}' has {} values.", new Object[]{this.getLogPrefix(), attribute.getId(), attribute.getValues().size()});
        List inputValues = attribute.getValues();
        ArrayList<IdPAttributeValue> outputValues = new ArrayList<IdPAttributeValue>(inputValues.size());
        for (Object o : inputValues) {
            if (o instanceof IdPAttributeValue) {
                outputValues.add((IdPAttributeValue)o);
                continue;
            }
            this.log.error("{} Attribute '{} has attribute value of type {}.  This will be ignored", new Object[]{this.getLogPrefix(), attribute.getId(), o.getClass().getName()});
        }
        attribute.setValues(outputValues);
    }

    private Map<String, IdPAttribute> buildResult(ScriptContext context) throws ResolutionException {
        Object res = context.getAttribute(RESULTS_STRING);
        if (null == res) {
            this.log.error("{} Could not locate output '{}' from script", (Object)this.getLogPrefix(), (Object)RESULTS_STRING);
            throw new ResolutionException("Could not locate output from script");
        }
        if (!(res instanceof Collection)) {
            this.log.error("{} Output '{}' was of type '{}', expected '{}'", new Object[]{this.getLogPrefix(), res.getClass().getName(), Collection.class.getName()});
            throw new ResolutionException("Output was of the wrong type");
        }
        Collection outputCollection = (Collection)res;
        HashMap<String, IdPAttribute> outputMap = new HashMap<String, IdPAttribute>(outputCollection.size());
        for (Object o : outputCollection) {
            if (o instanceof IdPAttribute) {
                IdPAttribute attribute = (IdPAttribute)o;
                if (null == attribute.getId()) {
                    this.log.error("{} Anonymous Attribute encountered, ignored", (Object)this.getLogPrefix());
                    continue;
                }
                this.checkValues(attribute);
                outputMap.put(attribute.getId(), attribute);
                continue;
            }
            this.log.error("{} Output collection contained an object of type '{}'.  This was ignored", (Object)this.getLogPrefix(), (Object)o.getClass().getName());
        }
        return outputMap;
    }

    @Nullable
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)resolutionContext, (String)"AttributeResolutionContext cannot be null");
        Constraint.isNotNull((Object)workContext, (String)"AttributeResolverWorkContext cannot be null");
        ScriptContext context = this.getScriptContext(resolutionContext, workContext);
        try {
            this.script.eval(context);
        }
        catch (ScriptException e) {
            throw new ResolutionException(this.getLogPrefix() + " unable to execute script", (Exception)e);
        }
        return this.buildResult(context);
    }
}

