/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.AbstractExecutableSearchFilterBuilder;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ExecutableSearchFilter;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.ldaptive.SearchFilter;

public class ParameterizedExecutableSearchFilterBuilder
extends AbstractExecutableSearchFilterBuilder {
    private final String searchFilter;

    public ParameterizedExecutableSearchFilterBuilder(@Nonnull String filter) {
        this.searchFilter = (String)Constraint.isNotNull((Object)filter, (String)"Search filter can not be null");
    }

    @Override
    public ExecutableSearchFilter build(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue<?>>> dependencyAttributes) throws ResolutionException {
        SearchFilter sf = new SearchFilter(this.searchFilter);
        sf.setParameter("principalName", (Object)resolutionContext.getPrincipal());
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue<?>>> entry : dependencyAttributes.entrySet()) {
                int i = 0;
                for (IdPAttributeValue<?> value : entry.getValue()) {
                    if (i == 0) {
                        sf.setParameter(String.format("%s", entry.getKey(), i), value.getValue());
                    }
                    sf.setParameter(String.format("%s[%s]", entry.getKey(), i++), value.getValue());
                }
            }
        }
        return super.build(sf);
    }
}

