/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.ad.impl.RegexSplitAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.spring.ad.BaseAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.PatternFactoryBean;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class RegexSplitAttributeDefinitionParser
extends BaseAttributeDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "RegexSplit");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RegexSplitAttributeDefinitionParser.class);

    protected Class<RegexSplitAttributeDefinition> getBeanClass(@Nullable Element element) {
        return RegexSplitAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String regexp = StringSupport.trimOrNull((String)config.getAttributeNS(null, "regex"));
        if (null == regexp) {
            this.log.error("{} No regexp specified.", (Object)this.getLogPrefix());
            throw new BeanCreationException(this.getLogPrefix() + " No regexp text provided.");
        }
        BeanDefinitionBuilder pattern = BeanDefinitionBuilder.genericBeanDefinition(PatternFactoryBean.class);
        pattern.addPropertyValue("regexp", (Object)regexp);
        if (config.hasAttributeNS(null, "caseSensitive")) {
            pattern.addPropertyValue("caseSensitive", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "caseSensitive")));
        }
        builder.addPropertyValue("regularExpression", (Object)pattern.getBeanDefinition());
    }

    @Override
    protected boolean needsAttributeSourceID() {
        return true;
    }
}

