/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.enc;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class BaseAttributeEncoderParser
extends AbstractSingleBeanDefinitionParser {
    @Nonnull
    @NotEmpty
    public static final String NAME_ATTRIBUTE_NAME = "name";
    private boolean nameRequired = false;

    public void setNameRequired(boolean flag) {
        this.nameRequired = flag;
    }

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        String attributeName = StringSupport.trimOrNull((String)config.getAttributeNS(null, NAME_ATTRIBUTE_NAME));
        if (this.nameRequired && attributeName == null) {
            throw new BeanCreationException("Attribute encoder must contain a name property");
        }
        if (config.hasAttributeNS(null, "activationConditionRef")) {
            builder.addPropertyReference("activationCondition", StringSupport.trimOrNull((String)config.getAttributeNS(null, "activationConditionRef")));
        }
        if (config.hasAttributeNS(null, "encodeType")) {
            builder.addPropertyValue("encodeType", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "encodeType")));
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        builder.addPropertyValue(NAME_ATTRIBUTE_NAME, (Object)attributeName);
    }

    public boolean shouldGenerateId() {
        return true;
    }

    protected boolean shouldParseNameAsAliases() {
        return false;
    }
}

