/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.config.DurationToLongConverter;
import net.shibboleth.ext.spring.config.StringBooleanToPredicateConverter;
import net.shibboleth.ext.spring.config.StringToIPRangeConverter;
import net.shibboleth.ext.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.ext.spring.resource.PreferFileSystemResourceLoader;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class SpringSupport {
    @Nonnull
    public static final QName SPRING_BEANS_ELEMENT_NAME = new QName("http://www.springframework.org/schema/beans", "beans");
    @Nonnull
    static final Logger LOG = LoggerFactory.getLogger(SpringSupport.class);

    private SpringSupport() {
    }

    @Nonnull
    public static GenericApplicationContext newContext(@Nonnull @NotEmpty String name, @Nonnull @NonnullElements List<Resource> configurationResources, @Nonnull @NonnullElements List<BeanFactoryPostProcessor> factoryPostProcessors, @Nonnull @NonnullElements List<BeanPostProcessor> postProcessors, @Nonnull @NonnullElements List<ApplicationContextInitializer> initializers, @Nullable ApplicationContext parentContext) {
        FilesystemGenericApplicationContext context = new FilesystemGenericApplicationContext(parentContext);
        context.setDisplayName("ApplicationContext:" + name);
        context.setResourceLoader((ResourceLoader)new PreferFileSystemResourceLoader());
        ConversionServiceFactoryBean service = new ConversionServiceFactoryBean();
        service.setConverters(new HashSet<Converter>(Arrays.asList(new DurationToLongConverter(), new StringToIPRangeConverter(), new StringBooleanToPredicateConverter())));
        service.afterPropertiesSet();
        for (BeanFactoryPostProcessor bfpp : factoryPostProcessors) {
            context.addBeanFactoryPostProcessor(bfpp);
        }
        context.getBeanFactory().setConversionService(service.getObject());
        for (BeanPostProcessor bpp : postProcessors) {
            context.getBeanFactory().addBeanPostProcessor(bpp);
        }
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.loadBeanDefinitions(configurationResources.toArray(new Resource[0]));
        if (initializers != null) {
            for (ApplicationContextInitializer initializer : initializers) {
                initializer.initialize((ConfigurableApplicationContext)context);
            }
        }
        context.refresh();
        return context;
    }

    @Nullable
    public static ManagedList<BeanDefinition> parseCustomElements(@Nullable @NonnullElements Collection<Element> elements, @Nonnull ParserContext parserContext) {
        if (elements == null) {
            return null;
        }
        ManagedList definitions = new ManagedList(elements.size());
        for (Element e : elements) {
            if (e == null) continue;
            definitions.add((Object)SpringSupport.parseCustomElement(e, parserContext));
        }
        return definitions;
    }

    @Nullable
    public static BeanDefinition parseCustomElement(@Nullable Element element, @Nonnull ParserContext parserContext) {
        if (element == null) {
            return null;
        }
        return parserContext.getDelegate().parseCustomElement(element);
    }

    public static void parseNativeElement(@Nonnull Element springBeans, @Nullable BeanDefinitionRegistry registry) {
        XmlBeanDefinitionReader definitionReader = new XmlBeanDefinitionReader(registry);
        definitionReader.setValidationMode(3);
        definitionReader.setNamespaceAware(true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SerializeSupport.writeNode((Node)springBeans, (OutputStream)outputStream);
        definitionReader.loadBeanDefinitions(new InputSource(new ByteArrayInputStream(outputStream.toByteArray())));
    }

    @Nonnull
    public static BeanFactory createBeanFactory(@Nonnull Element springBeans) {
        if (!springBeans.hasAttributeNS(XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getNamespaceURI(), XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getLocalPart())) {
            for (Node parent = springBeans.getParentNode(); parent != null && parent.getNodeType() == 1; parent = parent.getParentNode()) {
                String schemaLoc = ((Element)parent).getAttributeNS(XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getNamespaceURI(), XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getLocalPart());
                if (Strings.isNullOrEmpty((String)schemaLoc)) continue;
                springBeans.setAttributeNS(XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getNamespaceURI(), XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getPrefix() + ':' + XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getLocalPart(), schemaLoc);
                break;
            }
        }
        FilesystemGenericApplicationContext ctx = new FilesystemGenericApplicationContext();
        SpringSupport.parseNativeElement(springBeans, (BeanDefinitionRegistry)ctx);
        ctx.refresh();
        return ctx.getBeanFactory();
    }

    @Nullable
    public static <T> T getBean(@Nonnull BeanFactory beanFactory, @Nonnull Class<T> clazz) {
        Object bean = null;
        try {
            bean = beanFactory.getBean(clazz);
            LOG.debug("created spring bean {}", bean);
        }
        catch (NoSuchBeanDefinitionException e) {
            LOG.debug("no spring bean configured of type {}", clazz);
        }
        return (T)bean;
    }

    @Nonnull
    public static ManagedList<String> getAttributeValueAsManagedList(@Nullable Attr attribute) {
        List valuesAsList = AttributeSupport.getAttributeValueAsList((Attr)attribute);
        ManagedList managedList = new ManagedList(valuesAsList.size());
        managedList.addAll((Collection)valuesAsList);
        return managedList;
    }

    @Nonnull
    public static ManagedList<String> getElementTextContentAsManagedList(@Nullable Collection<Element> elements) {
        if (null == elements || elements.isEmpty()) {
            return new ManagedList(0);
        }
        ManagedList result = new ManagedList(elements.size());
        for (Element element : elements) {
            String textContent = StringSupport.trimOrNull((String)element.getTextContent());
            if (null == textContent) continue;
            result.add((Object)textContent);
        }
        return result;
    }
}

