/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.context;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.saml.ext.saml2mdui.Description;
import org.opensaml.saml.ext.saml2mdui.DisplayName;
import org.opensaml.saml.ext.saml2mdui.InformationURL;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.PrivacyStatementURL;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml.saml2.metadata.OrganizationName;
import org.opensaml.saml.saml2.metadata.OrganizationURL;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.ServiceDescription;
import org.opensaml.saml.saml2.metadata.ServiceName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelyingPartyUIContext
extends BaseContext {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RelyingPartyUIContext.class);
    @Nullable
    private EntityDescriptor rpEntityDescriptor;
    @Nullable
    private SPSSODescriptor rpSPSSODescriptor;
    @Nullable
    private AttributeConsumingService rpAttributeConsumingService;
    @Nullable
    private UIInfo rpUIInfo;
    @Nonnull
    @NonnullElements
    private List<String> browserLanguages = Collections.emptyList();
    @Nullable
    private List<String> fallbackLanguages;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private List<String> usableLanguages = Collections.emptyList();

    @Nullable
    protected EntityDescriptor getRPEntityDescriptor() {
        return this.rpEntityDescriptor;
    }

    @Nonnull
    public RelyingPartyUIContext setRPEntityDescriptor(@Nullable EntityDescriptor what) {
        this.rpEntityDescriptor = what;
        return this;
    }

    @Nullable
    protected SPSSODescriptor getRPSPSSODescriptor() {
        return this.rpSPSSODescriptor;
    }

    @Nonnull
    public RelyingPartyUIContext setRPSPSSODescriptor(@Nullable SPSSODescriptor what) {
        this.rpSPSSODescriptor = what;
        return this;
    }

    @Nullable
    protected AttributeConsumingService getRPAttributeConsumingService() {
        return this.rpAttributeConsumingService;
    }

    @Nullable
    protected UIInfo getRPUInfo() {
        return this.rpUIInfo;
    }

    @Nonnull
    public RelyingPartyUIContext setRPUInfo(@Nullable UIInfo what) {
        this.rpUIInfo = what;
        return this;
    }

    @Nonnull
    public RelyingPartyUIContext setRPAttributeConsumingService(@Nullable AttributeConsumingService what) {
        this.rpAttributeConsumingService = what;
        return this;
    }

    @Nonnull
    public RelyingPartyUIContext setBrowserLanguages(@Nonnull @NonnullElements List<String> languages) {
        this.browserLanguages = (List)Constraint.isNotNull(languages, (String)"Language List cannot be null");
        this.makeNewusableList();
        return this;
    }

    @Nonnull
    @NonnullElements
    protected List<String> getBrowserLanguages() {
        return this.browserLanguages;
    }

    @Nonnull
    public RelyingPartyUIContext setFallbackLanguages(@Nullable List<String> languages) {
        this.fallbackLanguages = languages;
        this.makeNewusableList();
        return this;
    }

    @Nonnull
    @NonnullElements
    protected List<String> getFallbackLanguages() {
        return this.fallbackLanguages;
    }

    protected void makeNewusableList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (null != this.browserLanguages) {
            builder.addAll(this.browserLanguages);
        }
        if (null != this.fallbackLanguages) {
            builder.addAll(this.fallbackLanguages);
        }
        this.usableLanguages = builder.build();
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    protected List<String> getUsableLanguages() {
        return this.usableLanguages;
    }

    @Nullable
    private String policeURL(@Nullable String url, @Nonnull @NotEmpty List<String> acceptableSchemes) {
        if (null == url) {
            this.log.trace("Empty Value - returning null");
            return null;
        }
        try {
            String scheme = new URI(url).getScheme();
            for (String acceptableScheme : acceptableSchemes) {
                if (!acceptableScheme.equals(scheme)) continue;
                this.log.debug("Acceptable Scheme '{}', returning value '{}'", (Object)acceptableScheme, (Object)url);
                return url;
            }
            this.log.warn("The logo URL '{}' contained an invalid scheme (expected '{}'), returning null", (Object)url, acceptableSchemes);
            return null;
        }
        catch (URISyntaxException e) {
            this.log.warn("The logo URL '{}' contained was not a URL, returning null", (Object)url);
            return null;
        }
    }

    protected String policeURLLogo(@Nullable String url) {
        return this.policeURL(url, Arrays.asList("http", "https", "data"));
    }

    protected String policeURLNonLogo(@Nullable String url) {
        return this.policeURL(url, Arrays.asList("http", "https", "mailto"));
    }

    @Nullable
    protected String getNameFromUIInfo(String lang) {
        if (this.getRPUInfo() != null) {
            for (DisplayName name : this.getRPUInfo().getDisplayNames()) {
                this.log.trace("Found name in UIInfo, language '{}'", (Object)name.getXMLLang());
                if (name.getXMLLang() == null || !name.getXMLLang().equals(lang)) continue;
                this.log.debug("Returning name from UIInfo '{}'", (Object)name.getValue());
                return name.getValue();
            }
        }
        this.log.trace("No name in UIINFO for '{}'", (Object)lang);
        return null;
    }

    @Nullable
    protected String getNameFromAttributeConsumingService(String lang) {
        if (null == this.getRPAttributeConsumingService()) {
            return null;
        }
        for (ServiceName name : this.getRPAttributeConsumingService().getNames()) {
            this.log.trace("Found name in AttributeConsumingService, language '{}'", (Object)name.getXMLLang());
            if (name.getXMLLang() == null || !name.getXMLLang().equals(lang)) continue;
            this.log.debug("Returning name from AttributeConsumingService '{}", (Object)name.getValue());
            return name.getValue();
        }
        this.log.trace("No name found in AttributeConsumingService for '{}'", (Object)lang);
        return null;
    }

    @Nullable
    protected String getNameFromEntityId() {
        if (null == this.getRPEntityDescriptor()) {
            this.log.trace("No relying party, no Name");
            return null;
        }
        String spName = this.getRPEntityDescriptor().getEntityID();
        try {
            URI entityId = new URI(spName);
            String scheme = entityId.getScheme();
            if ("http".equals(scheme) || "https".equals(scheme)) {
                this.log.debug("Found matching scheme, returning name of '{}'", (Object)entityId.getHost());
                return entityId.getHost();
            }
            this.log.debug("Not a usual scheme, returning name of '{}'", (Object)spName);
            return spName;
        }
        catch (URISyntaxException e) {
            this.log.debug("Not a URI, returning name of '{}'", (Object)spName);
            return spName;
        }
    }

    @Nullable
    protected String getDescriptionFromUIInfo(String lang) {
        if (this.getRPUInfo() == null || this.getRPUInfo().getDescriptions() == null) {
            this.log.trace("No UIInfo");
            return null;
        }
        for (Description desc : this.getRPUInfo().getDescriptions()) {
            this.log.trace("Found description in UIInfo, language '{}'", (Object)desc.getXMLLang());
            if (desc.getXMLLang() == null || !desc.getXMLLang().equals(lang)) continue;
            this.log.trace("Returning description from UIInfo '{}'", (Object)desc.getValue());
            return desc.getValue();
        }
        this.log.debug("No matching description in UIInfo");
        return null;
    }

    @Nullable
    protected String getDescriptionFromAttributeConsumingService(String lang) {
        if (this.getRPAttributeConsumingService() == null) {
            this.log.trace("No ACS found");
            return null;
        }
        for (ServiceDescription desc : this.getRPAttributeConsumingService().getDescriptions()) {
            this.log.trace("Found name in AttributeConsumingService, language=" + desc.getXMLLang());
            if (desc.getXMLLang() == null || !desc.getXMLLang().equals(lang)) continue;
            this.log.debug("Returning name from AttributeConsumingService " + desc.getValue());
            return desc.getValue();
        }
        this.log.trace("No description in AttributeConsumingService");
        return null;
    }

    @Nullable
    protected Organization getOrganization() {
        if (null != this.getRPSPSSODescriptor() && null != this.getRPSPSSODescriptor().getOrganization()) {
            return this.getRPSPSSODescriptor().getOrganization();
        }
        if (null != this.getRPEntityDescriptor() && null != this.getRPEntityDescriptor().getOrganization()) {
            return this.getRPEntityDescriptor().getOrganization();
        }
        return null;
    }

    protected ContactPersonTypeEnumeration getContactType(@Nullable String type) {
        String value = StringSupport.trimOrNull((String)type);
        if (null == value) {
            this.log.warn("no parameter provided to contactType");
            return ContactPersonTypeEnumeration.SUPPORT;
        }
        if (type.equals(ContactPersonTypeEnumeration.ADMINISTRATIVE.toString())) {
            return ContactPersonTypeEnumeration.ADMINISTRATIVE;
        }
        if (type.equals(ContactPersonTypeEnumeration.BILLING.toString())) {
            return ContactPersonTypeEnumeration.BILLING;
        }
        if (type.equals(ContactPersonTypeEnumeration.OTHER.toString())) {
            return ContactPersonTypeEnumeration.OTHER;
        }
        if (type.equals(ContactPersonTypeEnumeration.SUPPORT.toString())) {
            return ContactPersonTypeEnumeration.SUPPORT;
        }
        if (type.equals(ContactPersonTypeEnumeration.TECHNICAL.toString())) {
            return ContactPersonTypeEnumeration.TECHNICAL;
        }
        this.log.warn("parameter provided to contactType: " + type + " is invalid");
        return ContactPersonTypeEnumeration.SUPPORT;
    }

    @Nullable
    public ContactPerson getContactPerson(ContactPersonTypeEnumeration contactType) {
        if (null == this.getRPEntityDescriptor()) {
            return null;
        }
        List contacts = this.getRPEntityDescriptor().getContactPersons();
        if (null == contacts || contacts.isEmpty()) {
            this.log.trace("No Contacts found at all");
            return null;
        }
        for (ContactPerson contact : contacts) {
            if (contactType != contact.getType()) continue;
            return contact;
        }
        this.log.trace("No matching Contacts found at all");
        return null;
    }

    @Nullable
    public String getServiceName() {
        if (this.getRPEntityDescriptor() == null) {
            this.log.debug("No relying party, no name, returning null");
            return null;
        }
        for (String lang : this.getUsableLanguages()) {
            String result = this.getNameFromUIInfo(lang);
            if (result != null) {
                return result;
            }
            result = this.getNameFromAttributeConsumingService(lang);
            if (result == null) continue;
            return result;
        }
        return this.getNameFromEntityId();
    }

    @Nullable
    public String getServiceDescription() {
        for (String lang : this.getUsableLanguages()) {
            String value = this.getDescriptionFromUIInfo(lang);
            if (null != value) {
                return value;
            }
            value = this.getDescriptionFromAttributeConsumingService(lang);
            if (null == value) continue;
            return value;
        }
        this.log.debug("No description matching the languages found, returning null");
        return null;
    }

    @Nullable
    public String getOrganizationDisplayName() {
        Organization org = this.getOrganization();
        if (null == org || null == org.getDisplayNames() || org.getDisplayNames().isEmpty()) {
            this.log.debug("No Organization, OrganizationDisplayName or names, returning null");
            return null;
        }
        for (String lang : this.getUsableLanguages()) {
            for (OrganizationDisplayName name : org.getDisplayNames()) {
                this.log.trace("Found OrganizationDisplayName in Organization, language={}", (Object)name.getXMLLang());
                if (name.getXMLLang() == null || !name.getXMLLang().equals(lang)) continue;
                this.log.debug("Returning OrganizationDisplayName from Organization, {}", (Object)name.getValue());
                return name.getValue();
            }
        }
        this.log.debug("No relevant OrganizationDisplayName in Organization, returning null");
        return null;
    }

    @Nullable
    public String getOrganizationName() {
        Organization org = this.getOrganization();
        if (null == org || null == org.getOrganizationNames() || org.getOrganizationNames().isEmpty()) {
            this.log.debug("No Organization, OrganizationName or names, returning null");
            return null;
        }
        for (String lang : this.getUsableLanguages()) {
            for (OrganizationName name : org.getOrganizationNames()) {
                this.log.trace("Found OrganizationName in Organization, language={}", (Object)name.getXMLLang());
                if (name.getXMLLang() == null || !name.getXMLLang().equals(lang)) continue;
                this.log.debug("Returning OrganizationName from Organization, {}", (Object)name.getValue());
                return name.getValue();
            }
        }
        this.log.debug("No relevant OrganizationName in Organization, returning null");
        return null;
    }

    public String getOrganizationURL() {
        Organization org = this.getOrganization();
        if (null == org || null == org.getURLs() || org.getURLs().isEmpty()) {
            this.log.debug("No Organization, OrganizationURL or urls, returning null");
            return null;
        }
        for (String lang : this.getUsableLanguages()) {
            for (OrganizationURL url : org.getURLs()) {
                this.log.trace("Found OrganizationURL in Organization, language={}", (Object)url.getXMLLang());
                if (url.getXMLLang() == null || !url.getXMLLang().equals(lang)) continue;
                this.log.debug("Returning OrganizationURL from Organization, {}", (Object)url.getValue());
                return this.policeURLNonLogo(url.getValue());
            }
        }
        this.log.debug("No relevant OrganizationURL in Organization, returning null");
        return null;
    }

    @Nullable
    public String getContactSurName(@Nullable String contactType) {
        ContactPerson contact = this.getContactPerson(this.getContactType(contactType));
        if (null == contact || null == contact.getSurName()) {
            return null;
        }
        return contact.getSurName().getName();
    }

    @Nullable
    public String getContactGivenName(@Nullable String contactType) {
        ContactPerson contact = this.getContactPerson(this.getContactType(contactType));
        if (null == contact || null == contact.getGivenName()) {
            return null;
        }
        return contact.getGivenName().getName();
    }

    @Nullable
    public String getContactEmail(@Nullable String contactType) {
        ContactPerson contact = this.getContactPerson(this.getContactType(contactType));
        if (null == contact || null == contact.getEmailAddresses() || contact.getEmailAddresses().isEmpty()) {
            return null;
        }
        return this.policeURLNonLogo(((EmailAddress)contact.getEmailAddresses().get(0)).getAddress());
    }

    @Nullable
    public String getInformationURL() {
        if (null == this.getRPUInfo() || null == this.rpUIInfo.getInformationURLs() || this.rpUIInfo.getInformationURLs().isEmpty()) {
            this.log.debug("No UIInfo or InformationURLs returning null");
            return null;
        }
        for (String lang : this.getUsableLanguages()) {
            for (InformationURL url : this.rpUIInfo.getInformationURLs()) {
                this.log.trace("Found InformationURL, language={}", (Object)url.getXMLLang());
                if (url.getXMLLang() == null || !url.getXMLLang().equals(lang)) continue;
                this.log.debug("Returning InformationURL, {}", (Object)url.getValue());
                return this.policeURLNonLogo(url.getValue());
            }
        }
        this.log.debug("No relevant InformationURL with language match, returning null");
        return null;
    }

    @Nullable
    public String getPrivacyStatementURL() {
        if (null == this.getRPUInfo() || null == this.rpUIInfo.getPrivacyStatementURLs() || this.rpUIInfo.getPrivacyStatementURLs().isEmpty()) {
            this.log.debug("No UIInfo or PrivacyStatementURLs returning null");
            return null;
        }
        for (String lang : this.getUsableLanguages()) {
            for (PrivacyStatementURL url : this.rpUIInfo.getPrivacyStatementURLs()) {
                this.log.trace("Found PrivacyStatementURL, language={}", (Object)url.getXMLLang());
                if (url.getXMLLang() == null || !url.getXMLLang().equals(lang)) continue;
                this.log.debug("Returning PrivacyStatementURL, {}", (Object)url.getValue());
                return this.policeURLNonLogo(url.getValue());
            }
        }
        this.log.debug("No relevant PrivacyStatementURLs with language match, returning null");
        return null;
    }

    private boolean logoFits(Logo logo, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        return logo.getHeight() <= maxHeight && logo.getHeight() >= minHeight && logo.getWidth() <= maxWidth && logo.getWidth() >= minWidth;
    }

    @Nullable
    private String getLogoByLanguage(@Nonnull String lang, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        for (Logo logo : this.rpUIInfo.getLogos()) {
            this.log.trace("Found logo in UIInfo, '{}' ({} x {})", new Object[]{logo.getXMLLang(), logo.getWidth(), logo.getHeight()});
            if (logo.getXMLLang() == null || !logo.getXMLLang().equals(lang)) {
                this.log.trace("Language mismatch against '{}'");
                continue;
            }
            if (!this.logoFits(logo, minWidth, minHeight, maxWidth, maxHeight)) {
                this.log.trace("Size mismatch");
                continue;
            }
            this.log.debug("Returning logo from UIInfo, '{}' ({} x {}) : {}", new Object[]{logo.getXMLLang(), logo.getWidth(), logo.getHeight(), logo.getURL()});
            return logo.getURL();
        }
        return null;
    }

    @Nullable
    private String getLogoNoLanguage(int minWidth, int minHeight, int maxWidth, int maxHeight) {
        for (Logo logo : this.rpUIInfo.getLogos()) {
            if (null != logo.getXMLLang()) continue;
            this.log.trace("Found logo in UIInfo, ({} x {})", (Object)logo.getWidth(), (Object)logo.getHeight());
            if (!this.logoFits(logo, minWidth, minHeight, maxWidth, maxHeight)) {
                this.log.trace("Size Mismatch");
                continue;
            }
            this.log.debug("Returning logo from UIInfo, ({} x {}) : {}", new Object[]{logo.getWidth(), logo.getHeight(), logo.getURL()});
            return logo.getURL();
        }
        return null;
    }

    @Nullable
    public String getLogo(int minWidth, int minHeight, int maxWidth, int maxHeight) {
        if (null == this.getRPUInfo() || null == this.rpUIInfo.getLogos() || this.rpUIInfo.getLogos().isEmpty()) {
            this.log.debug("No UIInfo or logos returning null");
            return null;
        }
        for (String lang : this.getUsableLanguages()) {
            String result = this.getLogoByLanguage(lang, minWidth, minHeight, maxWidth, maxHeight);
            if (null == result) continue;
            return this.policeURLLogo(result);
        }
        String result = this.getLogoNoLanguage(minWidth, minHeight, maxWidth, maxHeight);
        if (null != result) {
            return this.policeURLLogo(result);
        }
        return null;
    }

    @Nullable
    public String getLogo(String minWidth, String minHeight, String maxWidth, String maxHeight) {
        int maxH;
        int maxW;
        int minH;
        int minW;
        try {
            minW = Integer.parseInt(minWidth);
        }
        catch (NumberFormatException ex) {
            minW = Integer.MIN_VALUE;
        }
        try {
            minH = Integer.parseInt(minHeight);
        }
        catch (NumberFormatException ex) {
            minH = Integer.MIN_VALUE;
        }
        try {
            maxW = Integer.parseInt(maxWidth);
        }
        catch (NumberFormatException ex) {
            maxW = Integer.MAX_VALUE;
        }
        try {
            maxH = Integer.parseInt(maxHeight);
        }
        catch (NumberFormatException ex) {
            maxH = Integer.MAX_VALUE;
        }
        return this.getLogo(minW, minH, maxW, maxH);
    }

    @Nullable
    public String getLogo() {
        return this.getLogo(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

