/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.tagext.BodyTagSupport;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.utilities.java.support.codec.HTMLEncoder;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTagSupport
extends BodyTagSupport {
    private static final long serialVersionUID = 4405207268569727209L;
    private static Logger log = LoggerFactory.getLogger(ServiceTagSupport.class);
    @Nonnull
    private static Function<ProfileRequestContext, RelyingPartyUIContext> uiContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(RelyingPartyUIContext.class), (Function)new ChildContextLookup(AuthenticationContext.class));
    @Nullable
    private String cssClass;
    @Nullable
    private String cssId;
    @Nullable
    private String cssStyle;
    @Nullable
    private RelyingPartyUIContext relyingPartyUIContext;

    public void setUiContext(@Nullable RelyingPartyUIContext value) {
        this.relyingPartyUIContext = value;
    }

    public void setCssClass(@Nullable String value) {
        this.cssClass = value;
    }

    public void setCssId(@Nullable String value) {
        this.cssId = value;
    }

    public void setCssStyle(@Nullable String value) {
        this.cssStyle = value;
    }

    protected void addClassAndId(@Nonnull StringBuilder sb) {
        if (this.cssClass != null) {
            sb.append(" class=\"").append(this.cssClass).append('\"');
        }
        if (this.cssId != null) {
            sb.append(" id=\"").append(this.cssId).append('\"');
        }
        if (this.cssStyle != null) {
            sb.append(" style=\"").append(this.cssStyle).append('\"');
        }
    }

    @Nonnull
    protected String buildHyperLink(@Nonnull String url, @Nonnull String text) {
        String encodedUrl;
        try {
            URI theUrl = new URI(url);
            String scheme = theUrl.getScheme();
            if (!("http".equals(scheme) || "https".equals(scheme) || "mailto".equals(scheme))) {
                log.warn("The URL '{}' contained an invalid scheme.", (Object)url);
                return "";
            }
            encodedUrl = HTMLEncoder.encodeForHTMLAttribute((String)url);
        }
        catch (URISyntaxException e) {
            log.warn("The URL '{}' was invalid: ", (Object)url, (Object)e);
            return "";
        }
        StringBuilder sb = new StringBuilder("<a href=\"");
        sb.append(encodedUrl).append('\"');
        this.addClassAndId(sb);
        sb.append(">").append(HTMLEncoder.encodeForHTML((String)text)).append("</a>");
        return sb.toString();
    }

    @Nullable
    protected RelyingPartyUIContext getRelyingPartyUIContext() {
        if (null != this.relyingPartyUIContext) {
            return this.relyingPartyUIContext;
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (request == null) {
            return null;
        }
        ProfileRequestContext pc = (ProfileRequestContext)request.getAttribute("profileRequestContext");
        return (RelyingPartyUIContext)((Object)uiContextLookupStrategy.apply((Object)pc));
    }

    @Nullable
    protected String getServiceName() {
        if (this.getRelyingPartyUIContext() == null) {
            return null;
        }
        return this.getRelyingPartyUIContext().getServiceName();
    }
}

