/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Function;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractActiveAuthenticationResults
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractActiveAuthenticationResults.class);
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextLookupStrategy = new ChildContextLookup(SessionContext.class);
    @Nullable
    private IdPSession session;

    public void setSessionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        SessionContext ctx = (SessionContext)this.sessionContextLookupStrategy.apply((Object)profileRequestContext);
        if (ctx != null) {
            this.session = ctx.getIdPSession();
            if (this.session != null) {
                return true;
            }
        }
        return false;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        ArrayList<AuthenticationResult> actives = new ArrayList<AuthenticationResult>();
        for (AuthenticationResult result : this.session.getAuthenticationResults()) {
            AuthenticationFlowDescriptor descriptor = (AuthenticationFlowDescriptor)authenticationContext.getPotentialFlows().get(result.getAuthenticationFlowId());
            if (descriptor == null) {
                this.log.debug("{} authentication result {} has no corresponding flow descriptor, considering inactive", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
                continue;
            }
            if (descriptor.isResultActive(result)) {
                this.log.debug("{} authentication result {} is active, copying from session", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
                actives.add(result);
                continue;
            }
            this.log.debug("{} authentication result {} is inactive, skipping it", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
        }
        if (actives.isEmpty()) {
            this.log.debug("{} no active authentication results, SSO will not be possible", (Object)this.getLogPrefix());
        }
        authenticationContext.setActiveResults(actives);
    }
}

