/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.cas.config.impl.AbstractProtocolConfiguration;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class LoginConfiguration
extends AbstractProtocolConfiguration
implements AuthenticationProfileConfiguration {
    public static final String PROFILE_ID = "https://www.apereo.org/cas/protocol/login";
    public static final String DEFAULT_TICKET_PREFIX = "ST";
    public static final int DEFAULT_TICKET_LENGTH = 25;
    @Nonnull
    @NonnullElements
    private Set<String> authenticationFlows = Collections.emptySet();
    @Nonnull
    @NonnullElements
    private List<String> postAuthenticationFlows = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private List<AuthnContextClassRefPrincipal> defaultAuthenticationContexts = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private List<String> nameIDFormatPrecedence = Collections.emptyList();

    public LoginConfiguration() {
        super(PROFILE_ID);
        this.setTicketValidityPeriod(15000L);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods() {
        return ImmutableList.copyOf(this.defaultAuthenticationContexts);
    }

    public void setDefaultAuthenticationMethods(@Nonnull @NonnullElements List<AuthnContextClassRefPrincipal> contexts) {
        Constraint.isNotNull(contexts, (String)"List of contexts cannot be null");
        this.defaultAuthenticationContexts = new ArrayList<AuthnContextClassRefPrincipal>(Collections2.filter(contexts, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows() {
        return ImmutableSet.copyOf(this.authenticationFlows);
    }

    public void setAuthenticationFlows(@Nonnull @NonnullElements Collection<String> flows) {
        Constraint.isNotNull(flows, (String)"Collection of flows cannot be null");
        this.authenticationFlows = new HashSet<String>(Collections2.filter(flows, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows() {
        return this.postAuthenticationFlows;
    }

    public void setPostAuthenticationFlows(@Nonnull @NonnullElements Collection<String> flows) {
        Constraint.isNotNull(flows, (String)"Collection of flows cannot be null");
        this.postAuthenticationFlows = new ArrayList<String>(StringSupport.normalizeStringCollection(flows));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence() {
        return ImmutableList.copyOf(this.nameIDFormatPrecedence);
    }

    public void setNameIDFormatPrecedence(@Nonnull @NonnullElements List<String> formats) {
        Constraint.isNotNull(formats, (String)"List of formats cannot be null");
        this.nameIDFormatPrecedence = new ArrayList<String>(Collections2.filter(formats, (Predicate)Predicates.notNull()));
    }

    @Override
    @Nonnull
    protected String getDefaultTicketPrefix() {
        return DEFAULT_TICKET_PREFIX;
    }

    @Override
    @Nonnull
    protected int getDefaultTicketLength() {
        return 25;
    }
}

