/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.profile.ActionSupport;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractOutgoingSamlMessageAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    private QName ENVELOPE_NAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope", "SOAP-ENV");
    private QName BODY_NAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body", "SOAP-ENV");
    protected static final String NAMESPACE = "http://www.ja-sig.org/products/cas/";

    protected static <T extends SAMLObject> T newSAMLObject(Class<T> type, QName elementName) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(elementName);
        return (T)builder.buildObject();
    }

    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgContext = new MessageContext();
        try {
            msgContext.setMessage((Object)this.buildSamlResponse(springRequestContext, (ProfileRequestContext<SAMLObject, SAMLObject>)profileRequestContext));
        }
        catch (IllegalStateException e) {
            return ProtocolError.IllegalState.event((Object)this);
        }
        SAMLBindingContext bindingContext = new SAMLBindingContext();
        bindingContext.setBindingUri("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        msgContext.addSubcontext((BaseContext)bindingContext);
        Envelope envelope = (Envelope)XMLObjectSupport.buildXMLObject((QName)this.ENVELOPE_NAME);
        envelope.setBody((Body)XMLObjectSupport.buildXMLObject((QName)this.BODY_NAME));
        SOAP11Context soapCtx = new SOAP11Context();
        soapCtx.setEnvelope(envelope);
        msgContext.addSubcontext((BaseContext)soapCtx);
        profileRequestContext.setOutboundMessageContext(msgContext);
        return ActionSupport.buildProceedEvent((Object)((Object)this));
    }

    protected abstract Response buildSamlResponse(@Nonnull RequestContext var1, @Nonnull ProfileRequestContext<SAMLObject, SAMLObject> var2);
}

