/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ValidateIdpSessionAction
extends AbstractCASProtocolAction {
    private final Logger log = LoggerFactory.getLogger(ValidateIdpSessionAction.class);
    @Nonnull
    private final SessionResolver sessionResolver;

    public ValidateIdpSessionAction(@Nonnull SessionResolver resolver) {
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"Session resolver cannot be null.");
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        boolean expired;
        IdPSession session;
        Ticket ticket = this.getCASTicket(profileRequestContext);
        String sessionId = ticket.getSessionId();
        try {
            this.log.debug("Attempting to retrieve session {}", (Object)sessionId);
            session = (IdPSession)this.sessionResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SessionIdCriterion(sessionId)}));
        }
        catch (ResolverException e) {
            this.log.debug("IdP session retrieval failed with error: {}", (Throwable)e);
            return ProtocolError.SessionRetrievalError.event((Object)this);
        }
        boolean bl = expired = session == null;
        if (session != null) {
            try {
                expired = !session.checkTimeout();
                this.log.debug("Session {} expired={}", (Object)sessionId, (Object)expired);
            }
            catch (SessionException e) {
                this.log.debug("Error performing session timeout check. Assuming session has expired.", (Throwable)e);
                expired = true;
            }
        }
        if (expired) {
            return ProtocolError.SessionExpired.event((Object)this);
        }
        SessionContext sessionContext = new SessionContext();
        sessionContext.setIdPSession(session);
        profileRequestContext.addSubcontext((BaseContext)sessionContext);
        return null;
    }
}

