/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.session.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class CASSPSession
extends BasicSPSession {
    @Nonnull
    @NotEmpty
    private final String ticketId;

    public CASSPSession(@Nonnull @NotEmpty String id, @Duration @Positive long creation, @Duration @Positive long expiration, @Nonnull @NotEmpty String ticketId) {
        super(id, creation, expiration);
        this.ticketId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)ticketId), (String)"Ticket ID cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getTicketId() {
        return this.ticketId;
    }

    public String getSPSessionKey() {
        return this.ticketId;
    }

    public String toString() {
        return "CASSPSession: " + this.getId() + " via " + this.ticketId;
    }
}

