/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.session.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.json.JsonObject;
import javax.json.stream.JsonGenerator;
import net.shibboleth.idp.cas.session.impl.CASSPSession;
import net.shibboleth.idp.session.AbstractSPSessionSerializer;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;

public class CASSPSessionSerializer
extends AbstractSPSessionSerializer {
    @Nonnull
    @NotEmpty
    private static final String TICKET_FIELD = "st";

    public CASSPSessionSerializer(@Duration @NonNegative long offset) {
        super(offset);
    }

    protected void doSerializeAdditional(@Nonnull SPSession instance, @Nonnull JsonGenerator generator) {
        if (!(instance instanceof CASSPSession)) {
            throw new IllegalArgumentException("Expected instance of CASSPSession but got " + instance);
        }
        generator.write(TICKET_FIELD, ((CASSPSession)instance).getTicketId());
    }

    @Nonnull
    protected SPSession doDeserialize(@Nonnull JsonObject obj, @Nonnull @NotEmpty String id, long creation, long expiration) throws IOException {
        return new CASSPSession(id, creation, expiration, obj.getString(TICKET_FIELD));
    }
}

