/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.cas.ticket.serialization.impl.ProxyGrantingTicketSerializer;
import net.shibboleth.idp.cas.ticket.serialization.impl.ProxyTicketSerializer;
import net.shibboleth.idp.cas.ticket.serialization.impl.ServiceTicketSerializer;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.Instant;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTicketService
implements TicketService {
    private static final Map<Class<? extends Ticket>, String> CONTEXT_CLASS_MAP = new HashMap<Class<? extends Ticket>, String>();
    private static final Map<Class<? extends Ticket>, StorageSerializer<? extends Ticket>> SERIALIZER_MAP = new HashMap<Class<? extends Ticket>, StorageSerializer<? extends Ticket>>();
    private static final ServiceTicketSerializer ST_SERIALIZER = new ServiceTicketSerializer();
    private static final ProxyTicketSerializer PT_SERIALIZER = new ProxyTicketSerializer();
    private static final ProxyGrantingTicketSerializer PGT_SERIALIZER = new ProxyGrantingTicketSerializer();
    private final Logger log = LoggerFactory.getLogger(SimpleTicketService.class);
    @Nonnull
    private final StorageService storageService;

    public SimpleTicketService(@Nonnull StorageService service) {
        this.storageService = (StorageService)Constraint.isNotNull((Object)service, (String)"StorageService cannot be null.");
    }

    @Nonnull
    public ServiceTicket createServiceTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull String sessionId, @Nonnull String service, boolean renew) {
        ServiceTicket st = new ServiceTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), (String)Constraint.isNotNull((Object)sessionId, (String)"Session ID cannot be null"), (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null"), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), renew);
        this.store(st);
        return st;
    }

    @Nullable
    public ServiceTicket removeServiceTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        return this.delete(id, ServiceTicket.class);
    }

    @Nonnull
    public ProxyGrantingTicket createProxyGrantingTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull ServiceTicket serviceTicket) {
        Constraint.isNotNull((Object)serviceTicket, (String)"ServiceTicket cannot be null");
        ProxyGrantingTicket pgt = new ProxyGrantingTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), serviceTicket.getSessionId(), serviceTicket.getService(), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), null);
        this.store(pgt);
        return pgt;
    }

    @Nonnull
    public ProxyGrantingTicket createProxyGrantingTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull ProxyTicket proxyTicket) {
        Constraint.isNotNull((Object)proxyTicket, (String)"ProxyTicket cannot be null");
        ProxyGrantingTicket pgt = new ProxyGrantingTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), proxyTicket.getSessionId(), proxyTicket.getService(), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), proxyTicket.getPgtId());
        this.store(pgt);
        return pgt;
    }

    @Nullable
    public ProxyGrantingTicket fetchProxyGrantingTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        return this.read(id, ProxyGrantingTicket.class);
    }

    @Nullable
    public ProxyGrantingTicket removeProxyGrantingTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        ProxyGrantingTicket pgt = this.delete(id, ProxyGrantingTicket.class);
        return pgt;
    }

    @Nonnull
    public ProxyTicket createProxyTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull ProxyGrantingTicket pgt, @Nonnull String service) {
        Constraint.isNotNull((Object)pgt, (String)"ProxyGrantingTicket cannot be null");
        ProxyTicket pt = new ProxyTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), pgt.getSessionId(), (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null"), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), pgt.getId());
        this.store(pt);
        return pt;
    }

    @Nullable
    public ProxyTicket removeProxyTicket(@Nonnull String id) {
        return this.delete(id, ProxyTicket.class);
    }

    private <T extends Ticket> void store(T ticket) {
        String context = SimpleTicketService.context(ticket.getClass());
        this.log.debug("Storing {} in context {}", ticket, (Object)context);
        try {
            if (!this.storageService.create(context, ticket.getId(), ticket, SimpleTicketService.serializer(ticket.getClass()), Long.valueOf(ticket.getExpirationInstant().getMillis()))) {
                throw new RuntimeException("Failed to store ticket " + ticket);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to store ticket " + ticket, e);
        }
    }

    private <T extends Ticket> T delete(String id, Class<T> clazz) {
        T ticket = this.read(id, clazz);
        if (ticket == null) {
            return null;
        }
        try {
            String context = SimpleTicketService.context(clazz);
            this.log.debug("Attempting to delete {} from context {}", ticket, (Object)context);
            if (!this.storageService.delete(context, id)) {
                this.log.info("Failed deleting {}. Ticket probably expired from storage service.", (Object)id);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error deleting ticket " + id, e);
        }
        return ticket;
    }

    private <T extends Ticket> T read(String id, Class<T> clazz) {
        Ticket ticket;
        this.log.debug("Reading {}", (Object)id);
        try {
            String context = SimpleTicketService.context(clazz);
            StorageRecord record = this.storageService.read(context, id);
            if (record == null) {
                this.log.debug("{} not found in context {}", (Object)id, (Object)context);
                return null;
            }
            ticket = (Ticket)record.getValue(SimpleTicketService.serializer(clazz), context, id);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading ticket.");
        }
        return (T)ticket;
    }

    private static String context(Class<? extends Ticket> clazz) {
        return CONTEXT_CLASS_MAP.get(clazz);
    }

    private static <T extends Ticket> StorageSerializer<T> serializer(Class<T> clazz) {
        return SERIALIZER_MAP.get(clazz);
    }

    static {
        CONTEXT_CLASS_MAP.put(ServiceTicket.class, "https://www.apereo.org/cas/protocol/login");
        CONTEXT_CLASS_MAP.put(ProxyTicket.class, "https://www.apereo.org/cas/protocol/proxy");
        CONTEXT_CLASS_MAP.put(ProxyGrantingTicket.class, "https://www.apereo.org/cas/protocol/serviceValidate");
        SERIALIZER_MAP.put(ServiceTicket.class, ST_SERIALIZER);
        SERIALIZER_MAP.put(ProxyTicket.class, PT_SERIALIZER);
        SERIALIZER_MAP.put(ProxyGrantingTicket.class, PGT_SERIALIZER);
    }
}

