/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.serialization.impl;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.storage.StorageSerializer;

public abstract class AbstractTicketSerializer<T extends Ticket>
implements StorageSerializer<T> {
    private static final String DELIMITER = "::";
    private static final Pattern SPLIT_PATTERN = Pattern.compile("::");

    public void initialize() throws ComponentInitializationException {
    }

    public boolean isInitialized() {
        return true;
    }

    @Nonnull
    public String serialize(@Nonnull T ticket) throws IOException {
        String[] fields = this.extractFields(ticket);
        if (fields.length == 0) {
            throw new IllegalStateException("Ticket has no fields to serialize.");
        }
        StringBuilder sb = new StringBuilder(fields[0]);
        for (int i = 1; i < fields.length; ++i) {
            sb.append(DELIMITER).append(fields[i]);
        }
        return sb.toString();
    }

    @Nonnull
    public T deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        return this.createTicket(key, SPLIT_PATTERN.split(value));
    }

    @NotEmpty
    protected abstract String[] extractFields(@Nonnull T var1);

    @Nonnull
    protected abstract T createTicket(@Nonnull String var1, @NotEmpty String[] var2);
}

