/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.audit.impl;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.context.impl.ConsentContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class CurrentConsentIdsAuditExtractor
implements Function<ProfileRequestContext, Collection<String>> {
    @Nonnull
    private Function<ProfileRequestContext, ConsentContext> consentContextLookupStrategy;

    public CurrentConsentIdsAuditExtractor() {
        this.consentContextLookupStrategy = new ChildContextLookup(ConsentContext.class, false);
    }

    public CurrentConsentIdsAuditExtractor(@Nonnull Function<ProfileRequestContext, ConsentContext> strategy) {
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent context lookup strategy cannot be null");
    }

    @Nullable
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        ConsentContext consentContext = (ConsentContext)((Object)this.consentContextLookupStrategy.apply((Object)input));
        if (consentContext != null) {
            return consentContext.getCurrentConsents().keySet();
        }
        return Collections.emptyList();
    }
}

