/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.audit.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.context.impl.ConsentContext;
import net.shibboleth.idp.consent.impl.Consent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class CurrentConsentIsApprovedAuditExtractor
implements Function<ProfileRequestContext, Collection<Boolean>> {
    @Nonnull
    private Function<ProfileRequestContext, ConsentContext> consentContextLookupStrategy;

    public CurrentConsentIsApprovedAuditExtractor() {
        this.consentContextLookupStrategy = new ChildContextLookup(ConsentContext.class, false);
    }

    public CurrentConsentIsApprovedAuditExtractor(@Nonnull Function<ProfileRequestContext, ConsentContext> strategy) {
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent context lookup strategy cannot be null");
    }

    @Nullable
    public Collection<Boolean> apply(@Nullable ProfileRequestContext input) {
        ConsentContext consentContext = (ConsentContext)((Object)this.consentContextLookupStrategy.apply((Object)input));
        if (consentContext != null && !consentContext.getCurrentConsents().isEmpty()) {
            return Collections2.transform(consentContext.getCurrentConsents().values(), (Function)new Function<Consent, Boolean>(){

                public Boolean apply(Consent input) {
                    return input.isApproved();
                }
            });
        }
        return Collections.emptyList();
    }
}

