/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.ar.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.consent.context.impl.AttributeReleaseContext;
import net.shibboleth.idp.consent.flow.ar.impl.AttributeReleaseFlowDescriptor;
import net.shibboleth.idp.consent.flow.impl.AbstractConsentAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttributeReleaseAction
extends AbstractConsentAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAttributeReleaseAction.class);
    @Nullable
    private AttributeReleaseContext attributeReleaseContext;
    @Nonnull
    private Function<ProfileRequestContext, AttributeReleaseContext> attributeReleaseContextLookupStrategy = new ChildContextLookup(AttributeReleaseContext.class, false);
    @Nullable
    private AttributeReleaseFlowDescriptor attributeReleaseFlowDescriptor;
    @Nullable
    private AttributeContext attributeContext;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));

    public void setAttributeContextLookupStrategy(Function<ProfileRequestContext, AttributeContext> strategy) {
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Attribute context lookup strategy cannot be null");
    }

    public void setAttributeReleaseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeReleaseContext> strategy) {
        this.attributeReleaseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Attribute release context lookup strategy cannot be null");
    }

    @Nullable
    public AttributeReleaseContext getAttributeReleaseContext() {
        return this.attributeReleaseContext;
    }

    @Nullable
    public AttributeReleaseFlowDescriptor getAttributeReleaseFlowDescriptor() {
        return this.attributeReleaseFlowDescriptor;
    }

    @Nullable
    public AttributeContext getAttributeContext() {
        return this.attributeContext;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        this.attributeReleaseContext = (AttributeReleaseContext)((Object)this.attributeReleaseContextLookupStrategy.apply((Object)profileRequestContext));
        if (this.attributeReleaseContext == null) {
            this.log.debug("{} Unable to locate attribute release context within profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (!(interceptorContext.getAttemptedFlow() instanceof AttributeReleaseFlowDescriptor)) {
            this.log.debug("{} ProfileInterceptorFlowDescriptor is not an AttributeReleaseFlowDescriptor", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.attributeReleaseFlowDescriptor = (AttributeReleaseFlowDescriptor)interceptorContext.getAttemptedFlow();
        this.attributeContext = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        this.log.debug("{} Found attributeContext '{}'", (Object)this.getLogPrefix(), (Object)this.attributeContext);
        if (this.attributeContext == null) {
            this.log.warn("{} Unable to locate attribute context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAttributeContext");
            return false;
        }
        return super.doPreExecute(profileRequestContext, interceptorContext);
    }
}

