/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.ar.impl;

import com.google.common.base.Function;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.logic.impl.AttributeValuesHashFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class AttributeReleaseFlowDescriptor
extends ConsentFlowDescriptor {
    private boolean doNotRememberConsentAllowed;
    private boolean globalConsentAllowed;
    private boolean perAttributeConsentEnabled;
    @Nonnull
    private Function<Collection<IdPAttributeValue<?>>, String> attributeValuesHashFunction = new AttributeValuesHashFunction();

    public boolean isDoNotRememberConsentAllowed() {
        return this.doNotRememberConsentAllowed;
    }

    public boolean isGlobalConsentAllowed() {
        return this.globalConsentAllowed;
    }

    public boolean isPerAttributeConsentEnabled() {
        return this.perAttributeConsentEnabled;
    }

    @Nonnull
    public Function<Collection<IdPAttributeValue<?>>, String> getAttributeValuesHashFunction() {
        return this.attributeValuesHashFunction;
    }

    public void setDoNotRememberConsentAllowed(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.doNotRememberConsentAllowed = flag;
    }

    public void setGlobalConsentAllowed(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.globalConsentAllowed = flag;
    }

    public void setPerAttributeConsentEnabled(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.perAttributeConsentEnabled = flag;
    }

    public void setAttributeValuesHashFunction(@Nonnull Function<Collection<IdPAttributeValue<?>>, String> function) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeValuesHashFunction = (Function)Constraint.isNotNull(function, (String)"Attribute values hash function cannot be null");
    }
}

