/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.consent.context.impl.ConsentContext;
import net.shibboleth.idp.consent.flow.impl.AbstractConsentAction;
import net.shibboleth.idp.consent.impl.Consent;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractConsent
extends AbstractConsentAction {
    @Nonnull
    @NotEmpty
    public static final String CONSENT_IDS_REQUEST_PARAMETER = "_shib_idp_consentIds";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractConsent.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        ConsentContext consentContext = this.getConsentContext();
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.debug("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        String[] consentIdsRequestParameterValues = request.getParameterValues(CONSENT_IDS_REQUEST_PARAMETER);
        if (consentIdsRequestParameterValues == null) {
            this.log.debug("{} No consent choices available from user input", (Object)this.getLogPrefix());
            return;
        }
        Collection consentIds = StringSupport.normalizeStringCollection(Arrays.asList(consentIdsRequestParameterValues));
        this.log.debug("{} Extracted consent ids '{}' from request parameter '{}'", new Object[]{this.getLogPrefix(), consentIds, CONSENT_IDS_REQUEST_PARAMETER});
        Map<String, Consent> currentConsents = this.getConsentContext().getCurrentConsents();
        for (Consent consent : currentConsents.values()) {
            if (consentIds.contains(consent.getId())) {
                consent.setApproved(Boolean.TRUE);
                continue;
            }
            consent.setApproved(Boolean.FALSE);
        }
        this.log.debug("{} Consent context '{}'", (Object)this.getLogPrefix(), (Object)consentContext);
    }
}

