/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageAction;
import net.shibboleth.idp.consent.storage.impl.CollectionSerializer;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorResult;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConsentIndexedStorageAction
extends AbstractConsentStorageAction {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_STORAGE_INDEX_KEY = "_key_idx";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractConsentIndexedStorageAction.class);
    @Nullable
    private String storageIndexKey;
    @Nullable
    private Function<ProfileRequestContext, String> storageIndexKeyLookupStrategy;
    @Nullable
    private Function<Pair<ProfileRequestContext, List<String>>, List<String>> storageKeysStrategy;
    @Nonnull
    private StorageSerializer<Collection<String>> storageKeysSerializer;

    public AbstractConsentIndexedStorageAction() {
        this.setStorageKeysSerializer(new CollectionSerializer());
    }

    @Nonnull
    public StorageSerializer<Collection<String>> getStorageKeysSerializer() {
        return this.storageKeysSerializer;
    }

    public void setStorageIndexKeyLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageIndexKeyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Storage index key lookup strategy cannot be null");
    }

    public void setStorageKeysSerializer(@Nonnull StorageSerializer<Collection<String>> serializer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageKeysSerializer = (StorageSerializer)Constraint.isNotNull(serializer, (String)"Storage keys serializer cannot be null");
    }

    public void setStorageKeysStrategy(@Nonnull Function<Pair<ProfileRequestContext, List<String>>, List<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageKeysStrategy = (Function)Constraint.isNotNull(strategy, (String)"Storage keys strategy cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageIndexKeyLookupStrategy == null) {
            throw new ComponentInitializationException("Storage key lookup strategy cannot be null");
        }
        if (this.storageKeysSerializer == null) {
            throw new ComponentInitializationException("Storage keys serializer cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        if (!super.doPreExecute(profileRequestContext, interceptorContext)) {
            return false;
        }
        this.storageIndexKey = (String)this.storageIndexKeyLookupStrategy.apply((Object)profileRequestContext);
        this.log.trace("{} Storage index key '{}'", (Object)this.getLogPrefix(), (Object)this.storageIndexKey);
        if (this.storageIndexKey == null) {
            this.log.debug("{} No storage index key", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    @Nullable
    protected String getStorageIndexKey() {
        return this.storageIndexKey;
    }

    @Nonnull
    @NonnullElements
    protected List<String> getStorageKeysFromIndex() throws IOException {
        StorageRecord storageRecord = this.getStorageService().read(this.getStorageContext(), this.getStorageIndexKey());
        this.log.debug("{} Read storage record '{}' with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), storageRecord, this.getStorageContext(), this.getStorageIndexKey()});
        if (storageRecord == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>((Collection)storageRecord.getValue(this.getStorageKeysSerializer(), this.getStorageContext(), this.getStorageIndexKey()));
    }

    protected boolean addKeyToStorageIndex(@Nonnull String keyToAdd) throws IOException {
        StorageRecord storageRecord = this.getStorageService().read(this.getStorageContext(), this.getStorageIndexKey());
        this.log.debug("{} Read storage record '{}' with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), storageRecord, this.getStorageContext(), this.getStorageIndexKey()});
        if (storageRecord == null) {
            this.log.debug("{} Creating storage index with key '{}'", (Object)this.getLogPrefix(), (Object)keyToAdd);
            return this.getStorageService().create(this.getStorageContext(), this.getStorageIndexKey(), Collections.singletonList(keyToAdd), this.storageKeysSerializer, null);
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>(this.getStorageKeysFromIndex());
        if (keys.add(keyToAdd)) {
            this.log.debug("{} Updating storage index by adding key '{}'", (Object)this.getLogPrefix(), (Object)keyToAdd);
            return this.getStorageService().update(this.getStorageContext(), this.getStorageIndexKey(), keys, this.storageKeysSerializer, null);
        }
        this.log.debug("{} Storage key '{}' already indexed, nothing to do", (Object)this.getLogPrefix(), (Object)keyToAdd);
        return false;
    }

    protected boolean removeKeyFromStorageIndex(@Nonnull String keyToRemove) throws IOException {
        StorageRecord storageRecord = this.getStorageService().read(this.getStorageContext(), this.getStorageIndexKey());
        this.log.debug("{} Read storage record '{}' with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), storageRecord, this.getStorageContext(), this.getStorageIndexKey()});
        if (storageRecord == null) {
            this.log.debug("{} No storage record exists with context '{}' and key '{}', nothing to do", new Object[]{this.getLogPrefix(), this.getStorageContext(), this.getStorageIndexKey()});
            return false;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>(this.getStorageKeysFromIndex());
        if (keys.remove(keyToRemove)) {
            this.log.debug("{} Updating storage index by removing key '{}'", (Object)this.getLogPrefix(), (Object)keyToRemove);
            return this.getStorageService().update(this.getStorageContext(), this.storageIndexKey, keys, this.storageKeysSerializer, null);
        }
        this.log.debug("{} Storage key '{}' not indexed, nothing to do", (Object)this.getLogPrefix(), (Object)keyToRemove);
        return false;
    }

    protected void pruneStorageRecords(@Nonnull ProfileRequestContext profileRequestContext) throws IOException {
        List sortedKeys;
        ConsentFlowDescriptor flowDescriptor = this.getConsentFlowDescriptor();
        int maxStoredRecords = flowDescriptor.getMaximumNumberOfStoredRecords();
        if (this.getStorageService().getCapabilities().getValueSize() >= flowDescriptor.getExpandedStorageThreshold()) {
            maxStoredRecords = flowDescriptor.getExpandedNumberOfStoredRecords();
        }
        if (maxStoredRecords <= 0) {
            this.log.trace("{} Will not prune storage records, maximum number of records is not greater than zero", (Object)this.getLogPrefix());
            return;
        }
        List keys = this.getStorageKeysFromIndex();
        if (keys.size() < maxStoredRecords) {
            this.log.debug("{} Will not prune storage records, number of keys '{}' is less than max number of records '{}'", new Object[]{this.getLogPrefix(), keys.size(), maxStoredRecords});
            return;
        }
        if (this.storageKeysStrategy != null && (sortedKeys = (List)this.storageKeysStrategy.apply((Object)new Pair((Object)profileRequestContext, keys))) != null) {
            keys = sortedKeys;
        }
        int numberOfKeys = keys.size();
        Iterator<String> keysIterator = keys.iterator();
        while (keysIterator.hasNext() && numberOfKeys >= maxStoredRecords) {
            String keyToDelete = keysIterator.next();
            this.log.debug("{} Pruning storage record with key '{}'. There are '{}' records of max '{}' ", new Object[]{this.getLogPrefix(), keyToDelete, numberOfKeys, maxStoredRecords});
            this.log.debug("{} Deleting storage record with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), this.getStorageContext(), keyToDelete});
            boolean success = this.getStorageService().delete(this.getStorageContext(), keyToDelete);
            if (success) {
                --numberOfKeys;
            }
            this.log.debug("{} Removing key '{}' from storage index", (Object)this.getLogPrefix(), (Object)keyToDelete);
            this.removeKeyFromStorageIndex(keyToDelete);
        }
    }

    protected boolean storeResult(@Nonnull ProfileInterceptorResult result) throws IOException {
        String context = result.getStorageContext();
        String key = result.getStorageKey();
        String value = result.getStorageValue();
        Long expiration = result.getStorageExpiration();
        int attempts = 10;
        boolean success = false;
        do {
            if (success = this.getStorageService().create(context, key, value, expiration)) continue;
            success = this.getStorageService().update(context, key, value, expiration);
        } while (!success && attempts-- > 0);
        if (!success) {
            this.log.error("{} Exhausted retry attempts storing result '{}'", (Object)this.getLogPrefix(), (Object)result);
        }
        return success;
    }

    protected void storeResultWithIndex(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorResult result) throws IOException {
        this.pruneStorageRecords(profileRequestContext);
        this.storeResult(result);
        this.addKeyToStorageIndex(result.getStorageKey());
    }
}

