/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentIndexedStorageAction;
import net.shibboleth.idp.consent.impl.Consent;
import net.shibboleth.idp.consent.storage.impl.ConsentResult;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorResult;
import org.joda.time.DateTime;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateResult
extends AbstractConsentIndexedStorageAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CreateResult.class);

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        if (!super.doPreExecute(profileRequestContext, interceptorContext)) {
            return false;
        }
        if (this.getConsentContext().getCurrentConsents().isEmpty()) {
            this.log.debug("{} No result will be created because there are no current consents", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        try {
            Map<String, Consent> currentConsents = this.getConsentContext().getCurrentConsents();
            String value = this.getStorageSerializer().serialize(currentConsents);
            long expiration = DateTime.now().plus(this.getConsentFlowDescriptor().getLifetime().longValue()).getMillis();
            ConsentResult result = new ConsentResult(this.getStorageContext(), this.getStorageKey(), value, expiration);
            this.log.debug("{} Created consent result '{}'", (Object)this.getLogPrefix(), (Object)result);
            this.storeResultWithIndex(profileRequestContext, (ProfileInterceptorResult)result);
        }
        catch (IOException e) {
            this.log.debug("{} Unable to serialize consent", (Object)this.getLogPrefix(), (Object)e);
        }
    }
}

