/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class AttributePredicate
extends AbstractInitializableComponent
implements Predicate<IdPAttribute> {
    @Nonnull
    @NonnullElements
    private Set<String> whitelistedAttributeIds = Collections.emptySet();
    @Nonnull
    @NonnullElements
    private Set<String> blacklistedAttributeIds = Collections.emptySet();
    @Nullable
    private Pattern matchExpression;

    public void setWhitelistedAttributeIds(@Nonnull @NonnullElements Collection<String> whitelist) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.whitelistedAttributeIds = new HashSet<String>(StringSupport.normalizeStringCollection(whitelist));
    }

    public void setBlacklistedAttributeIds(@Nonnull @NonnullElements Collection<String> blacklist) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.blacklistedAttributeIds = new HashSet<String>(StringSupport.normalizeStringCollection(blacklist));
    }

    public void setAttributeIdMatchExpression(@Nullable Pattern expression) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.matchExpression = expression;
    }

    public boolean apply(@Nullable IdPAttribute input) {
        String attributeId = input.getId();
        if (!this.whitelistedAttributeIds.isEmpty() && !this.whitelistedAttributeIds.contains(attributeId)) {
            if (this.matchExpression == null) {
                return false;
            }
            return this.matchExpression.matcher(attributeId).matches();
        }
        return !this.blacklistedAttributeIds.contains(attributeId) && (this.matchExpression == null || this.matchExpression.matcher(attributeId).matches());
    }
}

