/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.context.impl.ConsentContext;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.impl.Consent;
import net.shibboleth.idp.consent.logic.impl.FlowDescriptorLookupFunction;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsConsentRequiredPredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IsConsentRequiredPredicate.class);
    @Nonnull
    private Function<ProfileRequestContext, ConsentContext> consentContextLookupStrategy = new ChildContextLookup(ConsentContext.class);
    @Nonnull
    private Function<ProfileRequestContext, ConsentFlowDescriptor> consentFlowDescriptorLookupStrategy = new FlowDescriptorLookupFunction<ConsentFlowDescriptor>(ConsentFlowDescriptor.class);

    public void setConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, ConsentContext> strategy) {
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent context lookup strategy cannot be null");
    }

    public void setConsentFlowDescriptorLookupStrategy(@Nonnull Function<ProfileRequestContext, ConsentFlowDescriptor> strategy) {
        this.consentFlowDescriptorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent flow descriptor lookup strategy cannot be null");
    }

    @Nullable
    public boolean apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            this.log.debug("Consent is not required, no profile request context");
            return false;
        }
        ConsentContext consentContext = (ConsentContext)((Object)this.consentContextLookupStrategy.apply((Object)input));
        if (consentContext == null) {
            this.log.debug("Consent is not required, no consent context");
            return false;
        }
        ConsentFlowDescriptor consentFlowDescriptor = (ConsentFlowDescriptor)((Object)this.consentFlowDescriptorLookupStrategy.apply((Object)input));
        if (consentFlowDescriptor == null) {
            this.log.debug("Consent is not required, no consent flow descriptor");
            return false;
        }
        Map<String, Consent> currentConsents = consentContext.getCurrentConsents();
        if (currentConsents.isEmpty()) {
            this.log.debug("Consent is not required, there are no current consents");
            return false;
        }
        Map<String, Consent> previousConsents = consentContext.getPreviousConsents();
        if (previousConsents.isEmpty()) {
            this.log.debug("Consent is required, no previous consents");
            return true;
        }
        for (Consent currentConsent : currentConsents.values()) {
            Consent previousConsent = previousConsents.get(currentConsent.getId());
            if (previousConsent == null) {
                this.log.debug("Consent is required, no previous consent for '{}'", (Object)currentConsent);
                return true;
            }
            if (!consentFlowDescriptor.compareValues() || Objects.equals(currentConsent.getValue(), previousConsent.getValue())) continue;
            this.log.debug("Consent is required, previous consent '{}' does not match current consent '{}'", (Object)previousConsent, (Object)currentConsent);
            return true;
        }
        this.log.debug("Consent is not required, previous consents match current consents");
        return false;
    }
}

