/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.impl.Consent;
import net.shibboleth.idp.consent.logic.impl.FlowDescriptorLookupFunction;
import net.shibboleth.idp.consent.logic.impl.HashFunction;
import net.shibboleth.idp.consent.logic.impl.LocaleLookupFunction;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.NoSuchMessageException;

public class MessageSourceConsentFunction
extends AbstractInitializableComponent
implements Function<ProfileRequestContext, Map<String, Consent>>,
MessageSourceAware {
    @Nonnull
    private Function<ProfileRequestContext, String> consentKeyLookupStrategy = new RelyingPartyIdLookupFunction();
    @Nonnull
    @NotEmpty
    private String consentValueMessageCodeSuffix = ".text";
    @Nonnull
    private Function<ProfileRequestContext, ConsentFlowDescriptor> consentFlowDescriptorLookupStrategy = new FlowDescriptorLookupFunction<ConsentFlowDescriptor>(ConsentFlowDescriptor.class);
    @Nonnull
    private Function<String, String> hashFunction = new HashFunction();
    @Nonnull
    private Function<ProfileRequestContext, Locale> localeLookupStrategy = new LocaleLookupFunction();
    @Nonnull
    private MessageSource messageSource;

    public void setMessageSource(MessageSource source) {
        this.messageSource = source;
    }

    public void setConsentKeyLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentKeyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent key lookup strategy cannot be null");
    }

    public void setConsentValueMessageCodeSuffix(@Nonnull @NotEmpty String suffix) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentValueMessageCodeSuffix = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)suffix), (String)"Consent value message code suffix cannot be null nor empty");
    }

    public void setConsentFlowDescriptorLookupStrategy(@Nonnull Function<ProfileRequestContext, ConsentFlowDescriptor> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentFlowDescriptorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent flow descriptor lookup strategy cannot be null");
    }

    public void setHashFunction(@Nonnull Function<String, String> function) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.hashFunction = (Function)Constraint.isNotNull(function, (String)"Hash function cannot be null");
    }

    public void setLocaleLookupStrategy(@Nonnull Function<ProfileRequestContext, Locale> strategy) {
        this.localeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Locale lookup strategy cannot be null");
    }

    @Nullable
    public Map<String, Consent> apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        Locale locale = this.getLocale(input);
        String id = this.getConsentId(input, locale);
        if (id != null) {
            String value;
            Consent consent = new Consent();
            consent.setId(id);
            if (this.isCompareValues(input) && (value = this.getConsentValueHash(id, locale)) != null) {
                consent.setValue(value);
            }
            return Collections.singletonMap(id, consent);
        }
        return Collections.emptyMap();
    }

    @Nullable
    protected String getConsentId(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull Locale locale) {
        try {
            String key = (String)this.consentKeyLookupStrategy.apply((Object)profileRequestContext);
            if (key != null) {
                return this.messageSource.getMessage(key, null, locale);
            }
        }
        catch (NoSuchMessageException noSuchMessageException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    protected String getConsentValue(@Nonnull @NotEmpty String consentId, @Nonnull Locale locale) {
        try {
            return this.messageSource.getMessage(consentId + this.consentValueMessageCodeSuffix, null, locale);
        }
        catch (NoSuchMessageException e) {
            return null;
        }
    }

    @Nullable
    protected String getConsentValueHash(@Nonnull @NotEmpty String consentId, @Nonnull Locale locale) {
        return (String)this.hashFunction.apply((Object)this.getConsentValue(consentId, locale));
    }

    @Nullable
    protected Locale getLocale(@Nonnull ProfileRequestContext profileRequestContext) {
        return (Locale)this.localeLookupStrategy.apply((Object)profileRequestContext);
    }

    protected boolean isCompareValues(@Nonnull ProfileRequestContext profileRequestContext) {
        ConsentFlowDescriptor consentFlowDescriptor = (ConsentFlowDescriptor)((Object)this.consentFlowDescriptorLookupStrategy.apply((Object)profileRequestContext));
        if (consentFlowDescriptor != null) {
            return consentFlowDescriptor.compareValues();
        }
        return false;
    }
}

