/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.storage.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionSerializer
extends AbstractInitializableComponent
implements StorageSerializer<Collection<String>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CollectionSerializer.class);
    @Nonnull
    private final JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(null);
    @Nonnull
    private final JsonReaderFactory readerFactory = Json.createReaderFactory(null);

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Collection<String> instance) throws IOException {
        Constraint.isNotNull(instance, (String)"Storage indexes cannot be null");
        Collection filteredInstance = Collections2.filter(instance, (Predicate)Predicates.notNull());
        StringWriter sink = new StringWriter(128);
        JsonGenerator gen = this.generatorFactory.createGenerator((Writer)sink);
        gen.writeStartArray();
        for (String element : filteredInstance) {
            gen.write(element);
        }
        gen.writeEnd();
        gen.close();
        String serialized = sink.toString();
        this.log.debug("Serialized '{}' as '{}'", instance, (Object)serialized);
        return serialized;
    }

    @Nonnull
    public Collection<String> deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(value));
        JsonStructure st = reader.read();
        if (!(st instanceof JsonArray)) {
            throw new IOException("Found invalid data structure");
        }
        ArrayList<String> collection = new ArrayList<String>();
        for (JsonValue arrayValue : (JsonArray)st) {
            if (!arrayValue.getValueType().equals((Object)JsonValue.ValueType.STRING)) continue;
            collection.add(((JsonString)arrayValue).getString());
        }
        this.log.debug("Deserialized context '{}' key '{}' value '{}' expiration '{}' as '{}'", new Object[]{context, key, value, expiration, collection});
        return collection;
    }
}

