/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config.navigate;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;

public class DecryptionConfigurationLookupFunction
extends AbstractRelyingPartyLookupFunction<List<DecryptionConfiguration>> {
    @Nullable
    private RelyingPartyConfigurationResolver rpResolver;

    public void setRelyingPartyConfigurationResolver(@Nullable RelyingPartyConfigurationResolver resolver) {
        this.rpResolver = resolver;
    }

    @Nullable
    public List<DecryptionConfiguration> apply(@Nullable ProfileRequestContext input) {
        SecurityConfiguration defaultConfig;
        ProfileConfiguration pc;
        ArrayList<DecryptionConfiguration> configs = new ArrayList<DecryptionConfiguration>();
        RelyingPartyContext rpc = (RelyingPartyContext)((Object)this.getRelyingPartyContextLookupStrategy().apply((Object)input));
        if (rpc != null && (pc = rpc.getProfileConfig()) != null && pc.getSecurityConfiguration() != null) {
            configs.add(pc.getSecurityConfiguration().getDecryptionConfiguration());
        }
        if (input != null && this.rpResolver != null && (defaultConfig = this.rpResolver.getDefaultSecurityConfiguration(input.getProfileId())) != null && defaultConfig.getDecryptionConfiguration() != null) {
            configs.add(defaultConfig.getDecryptionConfiguration());
        }
        configs.add(SecurityConfigurationSupport.getGlobalDecryptionConfiguration());
        return configs;
    }
}

