/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorResult;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public abstract class AbstractProfileInterceptorResult
extends AbstractIdentifiableInitializableComponent
implements ProfileInterceptorResult {
    @Nonnull
    @NotEmpty
    private String storageContext;
    @Nonnull
    @NotEmpty
    private String storageKey;
    @Nonnull
    @NotEmpty
    private String storageValue;
    @Nullable
    @Duration
    @Positive
    private Long storageExpiration;

    public AbstractProfileInterceptorResult(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Duration @Positive Long expiration) {
        this.storageContext = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)context), (String)"Storage context cannot be null nor empty");
        this.storageKey = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Storage key cannot be null nor empty");
        this.storageValue = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)value), (String)"Storage value cannot be null nor empty");
        if (expiration != null) {
            this.storageExpiration = Constraint.isGreaterThan((long)0L, (long)expiration, (String)"Storage expiration must be greater than 0");
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getStorageContext() {
        return this.storageContext;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getStorageKey() {
        return this.storageKey;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getStorageValue() {
        return this.storageValue;
    }

    @Override
    @Nullable
    @Positive
    public Long getStorageExpiration() {
        return this.storageExpiration;
    }
}

