/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.profile.logic.AbstractAttributePredicate;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateAttributePredicate
extends AbstractAttributePredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DateAttributePredicate.class);
    @Nonnull
    private final String attributeName;
    @Nonnull
    private final DateTimeFormatter dateTimeFormatter;
    @Nonnull
    private Duration systemTimeOffset = Duration.ZERO;

    public DateAttributePredicate(String attribute) {
        this(attribute, ISODateTimeFormat.dateOptionalTimeParser());
    }

    public DateAttributePredicate(String attribute, DateTimeFormatter formatter) {
        this.attributeName = (String)Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        this.dateTimeFormatter = (DateTimeFormatter)Constraint.isNotNull((Object)formatter, (String)"Formatter cannot be null");
    }

    public void setSystemTimeOffset(@Nonnull Duration offset) {
        this.systemTimeOffset = (Duration)Constraint.isNotNull((Object)offset, (String)"Offset cannot not be null");
    }

    @Override
    protected boolean hasMatch(Map<String, IdPAttribute> attributeMap) {
        IdPAttribute attribute = attributeMap.get(this.attributeName);
        if (attribute == null) {
            this.log.info("Attribute {} not found in context", (Object)this.attributeName);
            return false;
        }
        for (IdPAttributeValue value : attribute.getValues()) {
            if (!(value instanceof StringAttributeValue)) continue;
            String dateString = ((StringAttributeValue)value).getValue();
            try {
                if (!this.dateTimeFormatter.parseDateTime(dateString).plus((ReadableDuration)this.systemTimeOffset).isAfterNow()) continue;
                return true;
            }
            catch (RuntimeException e) {
                this.log.info("{} is not a valid date for the configured date parser", (Object)dateString);
            }
        }
        return false;
    }
}

