/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.cryptacular.util.CertUtil;
import org.cryptacular.util.KeyPairUtil;
import org.opensaml.security.x509.BasicX509Credential;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class BasicX509CredentialFactoryBean
implements FactoryBean<BasicX509Credential> {
    @Nullable
    private Resource keyResource;
    @Nullable
    private String keyPass;
    @Nullable
    private Resource certResource;
    @Nullable
    private String entityID;
    @Nullable
    private BasicX509Credential credential;

    public void setPrivateKeyResource(@Nonnull Resource res) {
        this.keyResource = (Resource)Constraint.isNotNull((Object)res, (String)"Private key resource cannot be null");
    }

    public void setPrivateKeyPassword(@Nullable String password) {
        this.keyPass = password;
    }

    public void setCertificateResource(@Nonnull Resource res) {
        this.certResource = (Resource)Constraint.isNotNull((Object)res, (String)"Certificate resource cannot be null");
    }

    public void setEntityId(@Nullable String id) {
        this.entityID = StringSupport.trimOrNull((String)id);
    }

    public BasicX509Credential getObject() throws Exception {
        if (this.credential == null) {
            PrivateKey key;
            X509Certificate certificate;
            if (this.certResource == null) {
                throw new BeanCreationException("Certificate resource must be provided in order to use this factory.");
            }
            try (InputStream is = this.certResource.getInputStream();){
                certificate = CertUtil.readCertificate((InputStream)is);
            }
            if (this.keyResource == null) {
                throw new BeanCreationException("Private key resource must be provided in order to use this factory.");
            }
            try (InputStream is = this.keyResource.getInputStream();){
                key = this.keyPass == null ? KeyPairUtil.readPrivateKey((InputStream)is) : KeyPairUtil.readPrivateKey((InputStream)is, (char[])this.keyPass.toCharArray());
            }
            this.credential = new BasicX509Credential(certificate, key);
            this.credential.setEntityId(this.entityID);
        }
        return this.credential;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return BasicX509Credential.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

