/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.spring.relyingparty.impl.AnonymousRelyingPartyParser;
import net.shibboleth.idp.profile.spring.relyingparty.impl.DefaultRelyingPartyParser;
import net.shibboleth.idp.profile.spring.relyingparty.impl.RelyingPartyParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.AbstractMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.MetadataNamespaceHandler;
import net.shibboleth.idp.profile.spring.relyingparty.security.impl.SecurityNamespaceHandler;
import net.shibboleth.idp.relyingparty.impl.DefaultRelyingPartyConfigurationResolver;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.security.x509.tls.impl.BasicClientTLSValidationConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureValidationConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class RelyingPartyGroupParser
extends AbstractSingleBeanDefinitionParser {
    private final Logger log = LoggerFactory.getLogger(RelyingPartyGroupParser.class);

    protected Class<DefaultRelyingPartyConfigurationResolver> getBeanClass(Element element) {
        return DefaultRelyingPartyConfigurationResolver.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        Map configChildren = ElementSupport.getIndexedChildElements((Element)element);
        builder.setLazyInit(true);
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        builder.addPropertyValue("id", (Object)("RelyingPartyGroup[" + parserContext.getReaderContext().getResource().getFilename() + "]"));
        this.seDefaultSecurityConfiguration(builder);
        ManagedList relyingParties = SpringSupport.parseCustomElements((Collection)((Collection)configChildren.get(RelyingPartyParser.ELEMENT_NAME)), (ParserContext)parserContext);
        if (null != relyingParties && relyingParties.size() > 0) {
            builder.addPropertyValue("relyingPartyConfigurations", (Object)relyingParties);
        }
        ManagedList defaultRps = SpringSupport.parseCustomElements((Collection)((Collection)configChildren.get(DefaultRelyingPartyParser.ELEMENT_NAME)), (ParserContext)parserContext);
        builder.addPropertyValue("defaultConfiguration", defaultRps.get(0));
        ManagedList anonRps = SpringSupport.parseCustomElements((Collection)((Collection)configChildren.get(AnonymousRelyingPartyParser.ELEMENT_NAME)), (ParserContext)parserContext);
        builder.addPropertyValue("unverifiedConfiguration", anonRps.get(0));
        SpringSupport.parseCustomElements((Collection)((Collection)configChildren.get(MetadataNamespaceHandler.METADATA_ELEMENT_NAME)), (ParserContext)parserContext);
        SpringSupport.parseCustomElements((Collection)((Collection)configChildren.get(SecurityNamespaceHandler.CREDENTIAL_ELEMENT_NAME)), (ParserContext)parserContext);
        SpringSupport.parseCustomElements((Collection)((Collection)configChildren.get(AbstractMetadataProviderParser.TRUST_ENGINE_ELEMENT_NAME)), (ParserContext)parserContext);
        List policies = (List)configChildren.get(SecurityNamespaceHandler.SECURITY_POLICY_NAME);
        if (null != policies && !policies.isEmpty()) {
            this.log.warn("{}: {} occurrence(s) of unsupported <SecurityPolicy/> elements have been ignored", (Object)parserContext.getReaderContext().getResource().getDescription(), (Object)policies.size());
        }
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    private void seDefaultSecurityConfiguration(BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder signatureValidationConfig = BeanDefinitionBuilder.genericBeanDefinition(BasicSignatureValidationConfiguration.class);
        signatureValidationConfig.addPropertyReference("signatureTrustEngine", "shibboleth.SignatureTrustEngine");
        BeanDefinitionBuilder tlsValidationConfig = BeanDefinitionBuilder.genericBeanDefinition(BasicClientTLSValidationConfiguration.class);
        tlsValidationConfig.addPropertyReference("x509TrustEngine", "shibboleth.X509TrustEngine");
        BeanDefinitionBuilder configuration = BeanDefinitionBuilder.genericBeanDefinition(SecurityConfiguration.class);
        configuration.addPropertyValue("signatureValidationConfiguration", (Object)signatureValidationConfig.getBeanDefinition());
        configuration.addPropertyValue("clientTLSValidationConfiguration", (Object)tlsValidationConfig.getBeanDefinition());
        builder.addPropertyValue("defaultSecurityConfiguration", (Object)configuration.getBeanDefinition());
    }
}

