/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import net.shibboleth.idp.profile.spring.relyingparty.metadata.AbstractMetadataProviderParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractDynamicMetadataProviderParser
extends AbstractMetadataProviderParser {
    private static final String DEFAULT_PARSER_POOL_REF = "shibboleth.ParserPool";

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        String timerRef = this.getTaskTimerRef(element);
        if (timerRef != null) {
            builder.addConstructorArgReference(timerRef);
        }
        if (element.hasAttributeNS(null, "refreshDelayFactor")) {
            builder.addPropertyValue("refreshDelayFactor", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "refreshDelayFactor")));
        }
        if (element.hasAttributeNS(null, "minCacheDuration")) {
            builder.addPropertyValue("minCacheDuration", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "minCacheDuration")));
        }
        if (element.hasAttributeNS(null, "maxCacheDuration")) {
            builder.addPropertyValue("maxCacheDuration", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxCacheDuration")));
        }
        if (element.hasAttributeNS(null, "maxIdleEntityData")) {
            builder.addPropertyValue("maxIdleEntityData", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxIdleEntityData")));
        }
        if (element.hasAttributeNS(null, "removeIdleEntityData")) {
            builder.addPropertyValue("removeIdleEntityData", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "removeIdleEntityData")));
        }
        if (element.hasAttributeNS(null, "cleanupTaskInterval")) {
            builder.addPropertyValue("cleanupTaskInterval", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "cleanupTaskInterval")));
        }
        builder.addPropertyReference("parserPool", this.getParserPoolRef(element));
    }

    protected String getTaskTimerRef(Element element) {
        if (element.hasAttributeNS(null, "taskTimerRef")) {
            return StringSupport.trimOrNull((String)StringSupport.trimOrNull((String)element.getAttributeNS(null, "taskTimerRef")));
        }
        return null;
    }

    protected String getParserPoolRef(Element element) {
        String parserPoolRef = null;
        if (element.hasAttributeNS(null, "parserPoolRef")) {
            parserPoolRef = StringSupport.trimOrNull((String)StringSupport.trimOrNull((String)element.getAttributeNS(null, "parserPoolRef")));
        }
        if (parserPoolRef == null) {
            parserPoolRef = DEFAULT_PARSER_POOL_REF;
        }
        return parserPoolRef;
    }
}

