/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.AbstractMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.FileCachingHttpClientFactoryBean;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.HttpClientFactoryBean;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.InMemoryCachingHttpClientFactoryBean;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.AbstractReloadingMetadataProviderParser;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.opensaml.security.httpclient.impl.SecurityEnhancedTLSSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTTPMetadataProviderParser
extends AbstractReloadingMetadataProviderParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "HTTPMetadataProvider");
    public static final QName TLS_TRUST_ENGINE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "TLSTrustEngine");
    private static final String METADATA_URL = "metadataURL";
    private static final String BASIC_AUTH_USER = "basicAuthUser";
    private static final String BASIC_AUTH_PASSWORD = "basicAuthPassword";
    private static final String DEFAULT_CACHING = "none";
    private final Logger log = LoggerFactory.getLogger(HTTPMetadataProviderParser.class);

    protected Class<? extends HTTPMetadataResolver> getNativeBeanClass(Element element) {
        return HTTPMetadataResolver.class;
    }

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        if (element.hasAttributeNS(null, "cacheDuration")) {
            this.log.error("{}: cacheDuration is not supported", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("cacheDuration is not supported", new Location(parserContext.getReaderContext().getResource())));
        }
        if (element.hasAttributeNS(null, "maintainExpiredMetadata")) {
            this.log.error("{}: maintainExpiredMetadata is not supported", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("maintainExpiredMetadata is not supported", new Location(parserContext.getReaderContext().getResource())));
        }
        boolean haveTLSTrustEngine = false;
        if (element.hasAttributeNS(null, "tlsTrustEngineRef")) {
            builder.addPropertyReference("tLSTrustEngine", StringSupport.trimOrNull((String)element.getAttributeNS(null, "tlsTrustEngineRef")));
            haveTLSTrustEngine = true;
        } else {
            BeanDefinition tlsTrustEngine = this.parseTLSTrustEngine(element, parserContext);
            if (tlsTrustEngine != null) {
                builder.addPropertyValue("tLSTrustEngine", (Object)tlsTrustEngine);
                haveTLSTrustEngine = true;
            }
        }
        if (element.hasAttributeNS(null, "httpClientRef")) {
            builder.addConstructorArgReference(StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpClientRef")));
            if (element.hasAttributeNS(null, "requestTimeout") || element.hasAttributeNS(null, "disregardSslCertificate") || element.hasAttributeNS(null, "disregardTLSCertificate") || element.hasAttributeNS(null, "proxyHost") || element.hasAttributeNS(null, "proxyPort") || element.hasAttributeNS(null, "proxyUser") || element.hasAttributeNS(null, "proxyPassword")) {
                this.log.warn("httpClientRef overrides settings for requestTimeout, disregardSslCertificate, disregardTLSCertificate, proxyHost, proxyPort, proxyUser and proxyPassword");
            }
        } else {
            builder.addConstructorArgValue((Object)this.buildHttpClient(element, parserContext, haveTLSTrustEngine));
        }
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, METADATA_URL)));
        if (element.hasAttributeNS(null, BASIC_AUTH_USER) || element.hasAttributeNS(null, BASIC_AUTH_PASSWORD)) {
            builder.addPropertyValue("basicCredentials", (Object)this.buildBasicCredentials(element));
        }
    }

    private BeanDefinition buildHttpClient(Element element, ParserContext parserContext, boolean haveTLSTrustEngine) {
        String caching = DEFAULT_CACHING;
        if (element.hasAttributeNS(null, "httpCaching")) {
            caching = StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpCaching"));
        }
        BeanDefinitionBuilder clientBuilder = null;
        switch (caching) {
            case "none": {
                clientBuilder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientFactoryBean.class);
                break;
            }
            case "file": {
                clientBuilder = BeanDefinitionBuilder.genericBeanDefinition(FileCachingHttpClientFactoryBean.class);
                if (element.hasAttributeNS(null, "httpCacheDirectory")) {
                    clientBuilder.addPropertyValue("cacheDirectory", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpCacheDirectory")));
                }
                if (element.hasAttributeNS(null, "httpMaxCacheEntries")) {
                    clientBuilder.addPropertyValue("maxCacheEntries", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpMaxCacheEntries")));
                }
                if (!element.hasAttributeNS(null, "httpMaxCacheEntrySize")) break;
                clientBuilder.addPropertyValue("maxCacheEntrySize", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpMaxCacheEntrySize")));
                break;
            }
            case "memory": {
                clientBuilder = BeanDefinitionBuilder.genericBeanDefinition(InMemoryCachingHttpClientFactoryBean.class);
                if (element.hasAttributeNS(null, "httpMaxCacheEntries")) {
                    clientBuilder.addPropertyValue("maxCacheEntries", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpMaxCacheEntries")));
                }
                if (!element.hasAttributeNS(null, "httpMaxCacheEntrySize")) break;
                clientBuilder.addPropertyValue("maxCacheEntrySize", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpMaxCacheEntrySize")));
                break;
            }
            default: {
                throw new BeanDefinitionParsingException(new Problem(String.format("Caching value '%s' is unsupported", caching), new Location(parserContext.getReaderContext().getResource())));
            }
        }
        clientBuilder.setLazyInit(true);
        if (element.hasAttributeNS(null, "requestTimeout")) {
            clientBuilder.addPropertyValue("connectionTimeout", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "requestTimeout")));
        }
        if (haveTLSTrustEngine) {
            clientBuilder.addPropertyValue("tLSSocketFactory", (Object)new SecurityEnhancedTLSSocketFactory(HttpClientSupport.buildNoTrustTLSSocketFactory(), (X509HostnameVerifier)new StrictHostnameVerifier()));
        }
        if (element.hasAttributeNS(null, "disregardTLSCertificate")) {
            clientBuilder.addPropertyValue("connectionDisregardTLSCertificate", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "disregardTLSCertificate")));
        } else if (element.hasAttributeNS(null, "disregardSslCertificate")) {
            this.log.warn("disregardSslCertificate is deprecated, please switch to disregardTLSCertificate");
            clientBuilder.addPropertyValue("connectionDisregardTLSCertificate", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "disregardSslCertificate")));
        }
        if (element.hasAttributeNS(null, "proxyHost")) {
            clientBuilder.addPropertyValue("connectionProxyHost", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "proxyHost")));
        }
        if (element.hasAttributeNS(null, "proxyPort")) {
            clientBuilder.addPropertyValue("connectionProxyPort", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "proxyPort")));
        }
        if (element.hasAttributeNS(null, "proxyUser")) {
            clientBuilder.addPropertyValue("connectionProxyUsername", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "proxyUser")));
        }
        if (element.hasAttributeNS(null, "proxyPassword")) {
            clientBuilder.addPropertyValue("connectionProxyPassword", (Object)element.getAttributeNS(null, "proxyPassword"));
        }
        return clientBuilder.getBeanDefinition();
    }

    private BeanDefinition buildBasicCredentials(Element element) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(UsernamePasswordCredentials.class);
        builder.setLazyInit(true);
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, BASIC_AUTH_USER)));
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, BASIC_AUTH_PASSWORD)));
        return builder.getBeanDefinition();
    }

    private BeanDefinition parseTLSTrustEngine(Element element, ParserContext parserContext) {
        Element tlsTrustEngine = ElementSupport.getFirstChildElement((Node)element, (QName)TLS_TRUST_ENGINE_ELEMENT_NAME);
        if (tlsTrustEngine != null) {
            Element trustEngine = ElementSupport.getFirstChildElement((Node)tlsTrustEngine, (QName)AbstractMetadataProviderParser.TRUST_ENGINE_ELEMENT_NAME);
            if (trustEngine != null) {
                return SpringSupport.parseCustomElement((Element)trustEngine, (ParserContext)parserContext);
            }
            this.log.warn("{}:, Element {} did not contain a {} child element", new Object[]{parserContext.getReaderContext().getResource().getDescription(), TLS_TRUST_ENGINE_ELEMENT_NAME, AbstractMetadataProviderParser.TRUST_ENGINE_ELEMENT_NAME});
        }
        return null;
    }
}

