/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.security.credential.impl;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.ResourceBackedMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.security.credential.impl.AbstractCredentialFactoryBean;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.cryptacular.util.KeyPairUtil;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.BasicX509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;

public abstract class AbstractX509CredentialFactoryBean
extends AbstractCredentialFactoryBean<BasicX509Credential> {
    private final Logger log = LoggerFactory.getLogger(ResourceBackedMetadataProviderParser.class);

    protected BasicX509Credential doCreateInstance() throws Exception {
        List<String> keyNames;
        BasicX509Credential credential;
        PrivateKey privateKey;
        List<X509Certificate> certificates = this.getCertificates();
        if (null == certificates || certificates.isEmpty()) {
            this.log.error("{}: No Certificates provided", (Object)this.getConfigDescription());
            throw new BeanCreationException("No Certificates provided");
        }
        X509Certificate entityCertificate = this.getEntityCertificate();
        if (null == entityCertificate) {
            entityCertificate = certificates.get(0);
        }
        if (null == (privateKey = this.getPrivateKey())) {
            credential = new BasicX509Credential(entityCertificate);
        } else {
            credential = new BasicX509Credential(entityCertificate, privateKey);
            if (!KeyPairUtil.isKeyPair((PublicKey)entityCertificate.getPublicKey(), (PrivateKey)privateKey)) {
                this.log.error("{}: Public and private keys do not match", (Object)this.getConfigDescription());
                throw new BeanCreationException("Public and private keys do not match");
            }
        }
        credential.setEntityCertificateChain(certificates);
        List<X509CRL> crls = this.getCRLs();
        if (null != crls && !crls.isEmpty()) {
            credential.setCRLs(crls);
        }
        if (null != this.getUsageType()) {
            credential.setUsageType(UsageType.valueOf((String)this.getUsageType()));
        }
        if (null != this.getEntityID()) {
            credential.setEntityId(this.getEntityID());
        }
        if (null != (keyNames = this.getKeyNames())) {
            credential.getKeyNames().addAll(keyNames);
        }
        return credential;
    }

    public Class<BasicX509Credential> getObjectType() {
        return BasicX509Credential.class;
    }

    @Nullable
    protected abstract X509Certificate getEntityCertificate();

    @Nonnull
    @NotEmpty
    protected abstract List<X509Certificate> getCertificates();

    @Nullable
    protected abstract PrivateKey getPrivateKey();

    @Nullable
    protected abstract List<X509CRL> getCRLs();
}

