/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.security.credential.impl;

import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.idp.profile.spring.relyingparty.security.credential.impl.AbstractBasicCredentialFactoryBean;
import org.cryptacular.util.KeyPairUtil;
import org.opensaml.security.crypto.KeySupport;
import org.springframework.beans.factory.BeanCreationException;

public class BasicInlineCredentialFactoryBean
extends AbstractBasicCredentialFactoryBean {
    @Nullable
    private byte[] publicKeyInfo;
    @Nullable
    private byte[] privateKeyInfo;
    @Nullable
    private byte[] secretKeyInfo;

    @Nullable
    public byte[] getPublicKeyInfo() {
        return this.publicKeyInfo;
    }

    public void setPublicKeyInfo(@Nullable byte[] info) {
        this.publicKeyInfo = info;
    }

    @Nullable
    public byte[] getPrivateKeyInfo() {
        return this.privateKeyInfo;
    }

    public void setPrivateKeyInfo(@Nullable byte[] info) {
        this.privateKeyInfo = info;
    }

    @Nullable
    public byte[] getSecretKeyInfo() {
        return this.secretKeyInfo;
    }

    public void setSecretKeyInfo(@Nullable byte[] info) {
        this.secretKeyInfo = info;
    }

    @Override
    @Nullable
    protected PublicKey getPublicKey() {
        if (null == this.getPublicKeyInfo()) {
            return null;
        }
        return KeyPairUtil.decodePublicKey((byte[])this.getPublicKeyInfo());
    }

    @Override
    @Nullable
    protected PrivateKey getPrivateKey() {
        if (null == this.getPrivateKeyInfo()) {
            return null;
        }
        return KeyPairUtil.decodePrivateKey((byte[])this.getPrivateKeyInfo(), (char[])this.getPrivateKeyPassword());
    }

    @Override
    @Nullable
    protected SecretKey getSecretKey() {
        if (null == this.getSecretKeyInfo()) {
            return null;
        }
        try {
            return KeySupport.decodeSecretKey((byte[])this.decodeSecretKey(this.getSecretKeyInfo()), (String)this.getSecretKeyAlgorithm());
        }
        catch (KeyException e) {
            throw new BeanCreationException("Could not decode secret key", (Throwable)e);
        }
    }
}

