/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.protocol;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.protocol.ProtocolParam;
import net.shibboleth.idp.cas.protocol.SamlParam;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.springframework.web.util.UriComponentsBuilder;

public class ServiceTicketResponse {
    @Nonnull
    private final String service;
    @Nonnull
    private final String ticket;
    private boolean saml;

    public ServiceTicketResponse(@Nonnull String service, @Nonnull String ticket) {
        this.service = (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null");
        this.ticket = (String)Constraint.isNotNull((Object)ticket, (String)"Ticket cannot be null");
    }

    @Nonnull
    public String getService() {
        return this.service;
    }

    @Nonnull
    public String getTicket() {
        return this.ticket;
    }

    public boolean isSaml() {
        return this.saml;
    }

    public void setSaml(boolean saml) {
        this.saml = saml;
    }

    public String getRedirectUrl() {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.service);
        if (this.saml) {
            builder.queryParam(SamlParam.SAMLart.name(), new Object[]{this.ticket});
        } else {
            builder.queryParam(ProtocolParam.Ticket.id(), new Object[]{this.ticket});
        }
        return builder.build().toUriString();
    }
}

