/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.protocol.AbstractProtocolResponse;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class TicketValidationResponse
extends AbstractProtocolResponse {
    @Nullable
    private String userName;
    @Nonnull
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    @Nullable
    private String pgtIou;
    @Nonnull
    private List<String> proxies = new ArrayList<String>();

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(@Nonnull String user) {
        Constraint.isNotNull((Object)user, (String)"Username cannot be null");
        this.userName = user;
    }

    @Nonnull
    public Map<String, List<String>> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void addAttribute(String name, String value) {
        List<String> values = this.attributes.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.attributes.put(name, values);
        }
        values.add(value);
    }

    @Nullable
    public String getPgtIou() {
        return this.pgtIou;
    }

    public void setPgtIou(@Nullable String pgtIou) {
        this.pgtIou = StringSupport.trimOrNull((String)pgtIou);
    }

    @Nonnull
    public List<String> getProxies() {
        return Collections.unmodifiableList(this.proxies);
    }

    public void addProxy(String proxy) {
        this.proxies.add(proxy);
    }
}

