/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class Service
implements Principal {
    @Nonnull
    @NotEmpty
    private final String serviceURL;
    @Nullable
    private final String group;
    private final boolean authorizedToProxy;
    private final boolean singleLogoutParticipant;

    public Service(@Nonnull @NotEmpty String url, @Nullable @NotEmpty String group, boolean proxy) {
        this(url, group, proxy, false);
    }

    public Service(@Nonnull @NotEmpty String url, @Nullable @NotEmpty String group, boolean proxy, boolean wantsSLO) {
        this.serviceURL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)url), (String)"Service URL cannot be null or empty");
        this.group = StringSupport.trimOrNull((String)group);
        this.authorizedToProxy = proxy;
        this.singleLogoutParticipant = wantsSLO;
    }

    @Override
    public String getName() {
        return this.serviceURL;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public boolean isAuthorizedToProxy() {
        return this.authorizedToProxy;
    }

    public boolean isSingleLogoutParticipant() {
        return this.singleLogoutParticipant;
    }

    @Override
    public String toString() {
        return this.serviceURL;
    }
}

