/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import org.ldaptive.AbstractConfig;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.ssl.SslConfig;

public class ConnectionConfig
extends AbstractConfig {
    private String ldapUrl;
    private long connectTimeout = -1L;
    private long responseTimeout = -1L;
    private SslConfig sslConfig;
    private boolean useSSL;
    private boolean useStartTLS;
    private ConnectionInitializer connectionInitializer;

    public ConnectionConfig() {
    }

    public ConnectionConfig(String url) {
        this.setLdapUrl(url);
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String url) {
        this.checkImmutable();
        this.checkStringInput(url, true);
        this.logger.trace("setting ldapUrl: {}", (Object)url);
        this.ldapUrl = url;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long time) {
        this.checkImmutable();
        this.logger.trace("setting connectTimeout: {}", (Object)time);
        this.connectTimeout = time;
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(long time) {
        this.checkImmutable();
        this.logger.trace("setting responseTimeout: {}", (Object)time);
        this.responseTimeout = time;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfig config) {
        this.checkImmutable();
        this.logger.trace("setting sslConfig: {}", (Object)config);
        this.sslConfig = config;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting useSSL: {}", (Object)b);
        this.useSSL = b;
    }

    public boolean getUseStartTLS() {
        return this.useStartTLS;
    }

    public void setUseStartTLS(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting useStartTLS: {}", (Object)b);
        this.useStartTLS = b;
    }

    public ConnectionInitializer getConnectionInitializer() {
        return this.connectionInitializer;
    }

    public void setConnectionInitializer(ConnectionInitializer initializer) {
        this.checkImmutable();
        this.logger.trace("setting connectionInitializer: {}", (Object)initializer);
        this.connectionInitializer = initializer;
    }

    public static ConnectionConfig newConnectionConfig(ConnectionConfig config) {
        ConnectionConfig cc = new ConnectionConfig();
        cc.setLdapUrl(config.getLdapUrl());
        cc.setConnectTimeout(config.getConnectTimeout());
        cc.setResponseTimeout(config.getResponseTimeout());
        cc.setSslConfig(config.getSslConfig());
        cc.setUseSSL(config.getUseSSL());
        cc.setUseStartTLS(config.getUseStartTLS());
        cc.setConnectionInitializer(config.getConnectionInitializer());
        return cc;
    }

    public String toString() {
        return String.format("[%s@%d::ldapUrl=%s, connectTimeout=%s, responseTimeout=%s, sslConfig=%s, useSSL=%s, useStartTLS=%s, connectionInitializer=%s]", this.getClass().getName(), this.hashCode(), this.ldapUrl, this.connectTimeout, this.responseTimeout, this.sslConfig, this.useSSL, this.useStartTLS, this.connectionInitializer);
    }
}

