/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.ldaptive.AbstractLdapBean;
import org.ldaptive.LdapUtils;
import org.ldaptive.SortBehavior;
import org.ldaptive.io.ValueTranscoder;

public class LdapAttribute
extends AbstractLdapBean {
    private static final int HASH_CODE_SEED = 313;
    private static final long serialVersionUID = -3902233717232754155L;
    private String attributeName;
    private final LdapAttributeValues<?> attributeValues;

    public LdapAttribute() {
        this(SortBehavior.getDefaultSortBehavior(), false);
    }

    public LdapAttribute(SortBehavior sb) {
        this(sb, false);
    }

    public LdapAttribute(boolean binary) {
        this(SortBehavior.getDefaultSortBehavior(), binary);
    }

    public LdapAttribute(SortBehavior sb, boolean binary) {
        super(sb);
        this.attributeValues = binary ? new LdapAttributeValues<byte[]>(byte[].class) : new LdapAttributeValues<String>(String.class);
    }

    public LdapAttribute(String name) {
        this();
        this.setName(name);
    }

    public LdapAttribute(String name, String ... values) {
        this(false);
        this.setName(name);
        this.addStringValue(values);
    }

    public LdapAttribute(String name, byte[] ... values) {
        this(true);
        this.setName(name);
        this.addBinaryValue(values);
    }

    public String getName() {
        return this.getName(true);
    }

    public String getName(boolean withOptions) {
        if (withOptions) {
            return this.attributeName;
        }
        int optionIndex = this.attributeName.indexOf(";");
        return optionIndex > 0 ? this.attributeName.substring(0, optionIndex) : this.attributeName;
    }

    public void setName(String name) {
        this.attributeName = name;
    }

    public String[] getOptions() {
        String[] split;
        String[] options = null;
        if (this.attributeName.indexOf(";") > 0 && (split = this.attributeName.split(";")).length > 1) {
            options = new String[split.length - 1];
            System.arraycopy(split, 1, options, 0, options.length);
        }
        return options != null ? options : new String[]{};
    }

    public Collection<String> getStringValues() {
        return this.attributeValues.getStringValues();
    }

    public String getStringValue() {
        Collection<String> values = this.getStringValues();
        if (values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    public Collection<byte[]> getBinaryValues() {
        return this.attributeValues.getBinaryValues();
    }

    public byte[] getBinaryValue() {
        Collection<byte[]> values = this.getBinaryValues();
        if (values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    public boolean isBinary() {
        return this.attributeValues.isType(byte[].class);
    }

    public <T> Collection<T> getValues(ValueTranscoder<T> transcoder) {
        Collection<T> values = this.createSortBehaviorCollection(transcoder.getType());
        if (this.isBinary()) {
            for (byte[] b : this.getBinaryValues()) {
                values.add(transcoder.decodeBinaryValue(b));
            }
        } else {
            for (String s : this.getStringValues()) {
                values.add(transcoder.decodeStringValue(s));
            }
        }
        return values;
    }

    public <T> T getValue(ValueTranscoder<T> transcoder) {
        Collection<T> t = this.getValues(transcoder);
        if (t.isEmpty()) {
            return null;
        }
        return t.iterator().next();
    }

    public void addStringValue(String ... value) {
        for (String s : value) {
            this.attributeValues.add(s);
        }
    }

    public void addStringValues(Collection<String> values) {
        for (String value : values) {
            this.addStringValue(value);
        }
    }

    public void addBinaryValue(byte[] ... value) {
        for (byte[] b : value) {
            this.attributeValues.add(b);
        }
    }

    public void addBinaryValues(Collection<byte[]> values) {
        for (byte[] value : values) {
            this.addBinaryValue(new byte[][]{value});
        }
    }

    public <T> void addValue(ValueTranscoder<T> transcoder, T ... value) {
        for (T t : value) {
            if (this.isBinary()) {
                this.attributeValues.add(transcoder.encodeBinaryValue(t));
                continue;
            }
            this.attributeValues.add(transcoder.encodeStringValue(t));
        }
    }

    public <T> void addValues(ValueTranscoder<T> transcoder, Collection<T> values) {
        for (T value : values) {
            this.addValue(transcoder, value);
        }
    }

    public void removeStringValue(String ... value) {
        for (String s : value) {
            this.attributeValues.remove(s);
        }
    }

    public void removeStringValues(Collection<String> values) {
        for (String value : values) {
            this.removeStringValue(value);
        }
    }

    public void removeBinaryValue(byte[] ... value) {
        for (byte[] b : value) {
            this.attributeValues.remove(b);
        }
    }

    public void removeBinaryValues(Collection<byte[]> values) {
        for (byte[] value : values) {
            this.removeBinaryValue(new byte[][]{value});
        }
    }

    public int size() {
        return this.attributeValues.size();
    }

    public void clear() {
        this.attributeValues.clear();
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(313, this.attributeName != null ? this.attributeName.toLowerCase() : null, this.attributeValues);
    }

    public String toString() {
        return String.format("[%s%s]", this.attributeName, this.attributeValues);
    }

    protected <E> Collection<E> createSortBehaviorCollection(Class<E> c) {
        AbstractSet values = null;
        if (SortBehavior.UNORDERED == this.getSortBehavior()) {
            values = new HashSet();
        } else if (SortBehavior.ORDERED == this.getSortBehavior()) {
            values = new LinkedHashSet();
        } else if (SortBehavior.SORTED == this.getSortBehavior()) {
            values = !c.isAssignableFrom(Comparable.class) ? new TreeSet<E>(LdapAttribute.getComparator(c)) : new TreeSet();
        }
        return values;
    }

    private static <E> Comparator<E> getComparator(Class<E> c) {
        if (c.isAssignableFrom(byte[].class)) {
            return new Comparator<E>(){

                @Override
                public int compare(E o1, E o2) {
                    ByteBuffer bb1 = ByteBuffer.wrap((byte[])o1);
                    ByteBuffer bb2 = ByteBuffer.wrap((byte[])o2);
                    return bb1.compareTo(bb2);
                }
            };
        }
        return new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
    }

    public static LdapAttribute createLdapAttribute(SortBehavior sb, String name, Collection<Object> values) {
        LdapAttribute la;
        ArrayList<String> stringValues = new ArrayList<String>();
        ArrayList<byte[]> binaryValues = new ArrayList<byte[]>();
        for (Object value : values) {
            if (value instanceof byte[]) {
                binaryValues.add((byte[])value);
                continue;
            }
            if (value instanceof String) {
                stringValues.add((String)value);
                continue;
            }
            throw new IllegalArgumentException("Values must contain either String or byte[]");
        }
        if (!binaryValues.isEmpty()) {
            la = new LdapAttribute(sb, true);
            la.setName(name);
            la.addBinaryValues(binaryValues);
        } else {
            la = new LdapAttribute(sb, false);
            la.setName(name);
            la.addStringValues(stringValues);
        }
        return la;
    }

    public static String escapeValue(String value) {
        int len = value.length();
        StringBuilder sb = new StringBuilder(len);
        block5: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    sb.append('\\').append(ch);
                    continue block5;
                }
                case ' ': {
                    if (i == 0 || i + 1 == len) {
                        sb.append('\\').append(ch);
                        continue block5;
                    }
                    sb.append(ch);
                    continue block5;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block5;
                }
                default: {
                    if (ch < ' ' || ch == '\u007f') {
                        sb.append(LdapUtils.hexEncode(ch));
                        continue block5;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private class LdapAttributeValues<T>
    implements Serializable {
        private static final int HASH_CODE_SEED = 317;
        private static final long serialVersionUID = 8075255677989836494L;
        private final Class<T> type;
        private final Collection<T> values;

        public LdapAttributeValues(Class<T> t) {
            if (!t.isAssignableFrom(String.class) && !t.isAssignableFrom(byte[].class)) {
                throw new IllegalArgumentException("Only String and byte[] values are supported");
            }
            this.type = t;
            this.values = LdapAttribute.this.createSortBehaviorCollection(this.type);
        }

        public boolean isType(Class<?> c) {
            return this.type.isAssignableFrom(c);
        }

        public Collection<String> getStringValues() {
            if (this.isType(String.class)) {
                return Collections.unmodifiableCollection(this.values);
            }
            return Collections.unmodifiableCollection(this.convertValuesToString(this.values));
        }

        public Collection<byte[]> getBinaryValues() {
            if (this.isType(byte[].class)) {
                return Collections.unmodifiableCollection(this.values);
            }
            return Collections.unmodifiableCollection(this.convertValuesToByteArray(this.values));
        }

        public void add(Object o) {
            this.checkValue(o);
            this.values.add(this.type.cast(o));
        }

        public void remove(Object o) {
            this.checkValue(o);
            this.values.remove(this.type.cast(o));
        }

        private void checkValue(Object o) {
            if (o == null) {
                throw new IllegalArgumentException("Value cannot be null");
            }
            if (!this.isType(o.getClass())) {
                throw new IllegalArgumentException(String.format("Attribute %s does not support values of type %s", LdapAttribute.this.attributeName, o.getClass().isArray() ? o.getClass().getComponentType() : o.getClass().getName()));
            }
        }

        public int size() {
            return this.values.size();
        }

        public void clear() {
            this.values.clear();
        }

        public int hashCode() {
            return LdapUtils.computeHashCode(317, this.values);
        }

        public String toString() {
            return this.getStringValues().toString();
        }

        protected Collection<String> convertValuesToString(Collection<byte[]> v) {
            Collection<String> c = LdapAttribute.this.createSortBehaviorCollection(String.class);
            for (byte[] value : v) {
                c.add(LdapUtils.base64Encode(value));
            }
            return c;
        }

        protected Collection<byte[]> convertValuesToByteArray(Collection<String> v) {
            Collection<byte[]> c = LdapAttribute.this.createSortBehaviorCollection(byte[].class);
            for (String value : v) {
                c.add(LdapUtils.utf8Encode(value));
            }
            return c;
        }
    }
}

