/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ldaptive.LdapUtils;

public class SearchFilter {
    private static final int HASH_CODE_SEED = 311;
    private String searchFilter;
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    public SearchFilter() {
    }

    public SearchFilter(String filter) {
        this.setFilter(filter);
    }

    public SearchFilter(String filter, Object[] params) {
        this.setFilter(filter);
        this.setParameters(params);
    }

    public String getFilter() {
        return this.searchFilter;
    }

    public void setFilter(String filter) {
        this.searchFilter = filter;
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setParameter(int position, Object value) {
        this.parameters.put(Integer.toString(position), value);
    }

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public void setParameters(Object[] values) {
        int i = 0;
        for (Object o : values) {
            this.parameters.put(Integer.toString(i++), o);
        }
    }

    public String format() {
        String s = this.searchFilter;
        if (!this.parameters.isEmpty()) {
            for (Map.Entry<String, Object> e : this.parameters.entrySet()) {
                String encoded = SearchFilter.encode(e.getValue());
                if (encoded == null) continue;
                s = s.replace("{" + e.getKey() + "}", encoded);
            }
        }
        return s;
    }

    public static String encodeValue(byte[] value) {
        if (value == null) {
            return null;
        }
        char[] c = LdapUtils.hexEncode(value);
        StringBuilder sb = new StringBuilder(c.length + c.length / 2);
        for (int i = 0; i < c.length; i += 2) {
            sb.append('\\').append(c[i]).append(c[i + 1]);
        }
        return sb.toString();
    }

    public static String encodeValue(String value) {
        if (value == null) {
            return null;
        }
        return SearchFilter.escape(value);
    }

    protected static String encode(Object obj) {
        if (obj == null) {
            return null;
        }
        String str = obj instanceof String ? SearchFilter.encodeValue((String)obj) : (obj instanceof byte[] ? SearchFilter.encodeValue((byte[])obj) : SearchFilter.encodeValue(obj.toString()));
        return str;
    }

    private static String escape(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        return LdapUtils.areEqual(this, o);
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(311, this.searchFilter, this.parameters);
    }

    public String toString() {
        return String.format("[%s@%d::filter=%s, parameters=%s]", this.getClass().getName(), this.hashCode(), this.searchFilter, this.parameters);
    }
}

