/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import org.ldaptive.AbstractRequest;
import org.ldaptive.DerefAliases;
import org.ldaptive.LdapUtils;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchScope;
import org.ldaptive.SortBehavior;
import org.ldaptive.handler.SearchEntryHandler;
import org.ldaptive.handler.SearchReferenceHandler;

public class SearchRequest
extends AbstractRequest {
    private static final int HASH_CODE_SEED = 307;
    private String baseDn = "";
    private SearchFilter searchFilter;
    private String[] retAttrs = ReturnAttributes.DEFAULT.value();
    private SearchScope searchScope = SearchScope.SUBTREE;
    private long timeLimit;
    private long sizeLimit;
    private DerefAliases derefAliases;
    private boolean typesOnly;
    private String[] binaryAttrs;
    private SortBehavior sortBehavior = SortBehavior.getDefaultSortBehavior();
    private SearchEntryHandler[] entryHandlers;
    private SearchReferenceHandler[] referenceHandlers;

    public SearchRequest() {
    }

    public SearchRequest(String dn, SearchFilter filter) {
        this.setBaseDn(dn);
        this.setSearchFilter(filter);
    }

    public SearchRequest(String dn, SearchFilter filter, String ... attrs) {
        this.setBaseDn(dn);
        this.setSearchFilter(filter);
        this.setReturnAttributes(attrs);
    }

    public SearchRequest(String dn, String filter) {
        this.setBaseDn(dn);
        this.setSearchFilter(new SearchFilter(filter));
    }

    public SearchRequest(String dn, String filter, String ... attrs) {
        this.setBaseDn(dn);
        this.setSearchFilter(new SearchFilter(filter));
        this.setReturnAttributes(attrs);
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String dn) {
        this.baseDn = dn;
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(SearchFilter filter) {
        this.searchFilter = filter;
    }

    public String[] getReturnAttributes() {
        return this.retAttrs;
    }

    public void setReturnAttributes(String ... attrs) {
        this.retAttrs = ReturnAttributes.parse(attrs);
    }

    public SearchScope getSearchScope() {
        return this.searchScope;
    }

    public void setSearchScope(SearchScope scope) {
        this.searchScope = scope;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(long limit) {
        this.timeLimit = limit;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(long limit) {
        this.sizeLimit = limit;
    }

    public DerefAliases getDerefAliases() {
        return this.derefAliases;
    }

    public void setDerefAliases(DerefAliases da) {
        this.derefAliases = da;
    }

    public boolean getTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean b) {
        this.typesOnly = b;
    }

    public String[] getBinaryAttributes() {
        return this.binaryAttrs;
    }

    public void setBinaryAttributes(String ... attrs) {
        this.binaryAttrs = attrs;
    }

    public SortBehavior getSortBehavior() {
        return this.sortBehavior;
    }

    public void setSortBehavior(SortBehavior sb) {
        this.sortBehavior = sb;
    }

    public SearchEntryHandler[] getSearchEntryHandlers() {
        return this.entryHandlers;
    }

    public void setSearchEntryHandlers(SearchEntryHandler ... handlers) {
        if (handlers != null) {
            for (SearchEntryHandler handler : handlers) {
                handler.initializeRequest(this);
            }
        }
        this.entryHandlers = handlers;
    }

    public SearchReferenceHandler[] getSearchReferenceHandlers() {
        return this.referenceHandlers;
    }

    public void setSearchReferenceHandlers(SearchReferenceHandler ... handlers) {
        if (handlers != null) {
            for (SearchReferenceHandler handler : handlers) {
                handler.initializeRequest(this);
            }
        }
        this.referenceHandlers = handlers;
    }

    public static SearchRequest newObjectScopeSearchRequest(String dn) {
        return SearchRequest.newObjectScopeSearchRequest(dn, null);
    }

    public static SearchRequest newObjectScopeSearchRequest(String dn, String[] attrs) {
        return SearchRequest.newObjectScopeSearchRequest(dn, attrs, new SearchFilter("(objectClass=*)"));
    }

    public static SearchRequest newObjectScopeSearchRequest(String dn, String[] attrs, SearchFilter filter) {
        SearchRequest request = new SearchRequest();
        request.setBaseDn(dn);
        request.setSearchFilter(filter);
        request.setReturnAttributes(attrs);
        request.setSearchScope(SearchScope.OBJECT);
        return request;
    }

    protected static SearchRequest newSearchRequest(SearchRequest request) {
        SearchRequest sr = new SearchRequest();
        sr.setBaseDn(request.getBaseDn());
        sr.setBinaryAttributes(request.getBinaryAttributes());
        sr.setDerefAliases(request.getDerefAliases());
        sr.setSearchEntryHandlers(request.getSearchEntryHandlers());
        sr.setSearchReferenceHandlers(request.getSearchReferenceHandlers());
        sr.setFollowReferrals(request.getFollowReferrals());
        sr.setReturnAttributes(request.getReturnAttributes());
        sr.setSearchFilter(request.getSearchFilter());
        sr.setSearchScope(request.getSearchScope());
        sr.setSizeLimit(request.getSizeLimit());
        sr.setSortBehavior(request.getSortBehavior());
        sr.setTimeLimit(request.getTimeLimit());
        sr.setTypesOnly(request.getTypesOnly());
        sr.setControls(request.getControls());
        return sr;
    }

    public boolean equals(Object o) {
        return LdapUtils.areEqual(this, o);
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(307, new Object[]{this.baseDn, this.binaryAttrs, this.derefAliases, this.entryHandlers, this.referenceHandlers, this.retAttrs, this.searchFilter, this.searchScope, this.sizeLimit, this.sortBehavior, this.timeLimit, this.typesOnly, this.getControls(), this.getFollowReferrals(), this.getIntermediateResponseHandlers()});
    }

    public String toString() {
        return String.format("[%s@%d::baseDn=%s, searchFilter=%s, returnAttributes=%s, searchScope=%s, timeLimit=%s, sizeLimit=%s, derefAliases=%s, typesOnly=%s, binaryAttributes=%s, sortBehavior=%s, searchEntryHandlers=%s, searchReferenceHandlers=%s, controls=%s, followReferrals=%s, intermediateResponseHandlers=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.baseDn, this.searchFilter, Arrays.toString(this.retAttrs), this.searchScope, this.timeLimit, this.sizeLimit, this.derefAliases, this.typesOnly, Arrays.toString(this.binaryAttrs), this.sortBehavior, Arrays.toString(this.entryHandlers), Arrays.toString(this.referenceHandlers), Arrays.toString(this.getControls()), this.getFollowReferrals(), Arrays.toString(this.getIntermediateResponseHandlers())});
    }
}

