/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ad.handler;

import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchRequest;
import org.ldaptive.handler.AbstractSearchEntryHandler;

public abstract class AbstractBinaryAttributeHandler
extends AbstractSearchEntryHandler {
    private String attributeName;

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String name) {
        this.attributeName = name;
    }

    @Override
    protected void handleAttributes(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
        for (LdapAttribute la : entry.getAttributes()) {
            if (this.attributeName.equalsIgnoreCase(la.getName())) {
                if (la.isBinary()) {
                    LdapAttribute newAttr = new LdapAttribute(la.getSortBehavior());
                    newAttr.setName(la.getName());
                    for (byte[] b : la.getBinaryValues()) {
                        newAttr.addStringValue(this.convertValue(b));
                    }
                    entry.addAttribute(newAttr);
                    this.logger.debug("Processed attribute {}", (Object)newAttr);
                    this.handleAttribute(conn, request, newAttr);
                    continue;
                }
                this.logger.warn("Attribute {} must be set as a binary attribute", (Object)this.attributeName);
                this.handleAttribute(conn, request, la);
                continue;
            }
            this.handleAttribute(conn, request, la);
        }
    }

    protected abstract String convertValue(byte[] var1);

    @Override
    public void initializeRequest(SearchRequest request) {
        boolean isAttrSet = false;
        String[] binaryAttrs = request.getBinaryAttributes();
        if (binaryAttrs != null) {
            for (String attr : binaryAttrs) {
                if (!this.attributeName.equalsIgnoreCase(attr)) continue;
                isAttrSet = true;
                break;
            }
            if (!isAttrSet) {
                request.setBinaryAttributes(LdapUtils.concatArrays(binaryAttrs, new String[][]{{this.attributeName}}));
            }
        } else {
            request.setBinaryAttributes(this.attributeName);
        }
    }
}

