/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ad.handler;

import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.ad.SecurityIdentifier;
import org.ldaptive.handler.AbstractSearchEntryHandler;

public class PrimaryGroupIdHandler
extends AbstractSearchEntryHandler {
    private static final int HASH_CODE_SEED = 1831;
    private String groupFilter = "(&(objectClass=group)(objectSid={0}))";
    private String baseDn;

    public String getGroupFilter() {
        return this.groupFilter;
    }

    public void setGroupFilter(String filter) {
        this.groupFilter = filter;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String dn) {
        this.baseDn = dn;
    }

    @Override
    protected void handleAttributes(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
        LdapAttribute objectSid = entry.getAttribute("objectSid");
        LdapAttribute primaryGroupId = entry.getAttribute("primaryGroupID");
        this.logger.debug("found objectSid {} and primaryGroupID {}", (Object)objectSid, (Object)primaryGroupId);
        if (objectSid != null && primaryGroupId != null) {
            String sid = objectSid.isBinary() ? SecurityIdentifier.toString(objectSid.getBinaryValue()) : objectSid.getStringValue();
            String groupSid = sid.substring(0, sid.lastIndexOf(45) + 1) + primaryGroupId.getStringValue();
            this.logger.debug("created primary group SID {} from object SID {} and primaryGroupID {}", new Object[]{groupSid, sid, primaryGroupId.getStringValue()});
            SearchRequest sr = new SearchRequest();
            sr.setBaseDn(this.baseDn != null ? this.baseDn : request.getBaseDn());
            sr.setReturnAttributes(ReturnAttributes.NONE.value());
            sr.setSearchFilter(new SearchFilter(this.groupFilter, new Object[]{groupSid}));
            SearchOperation search = new SearchOperation(conn);
            SearchResult result = (SearchResult)search.execute(sr).getResult();
            if (result.size() == 0) {
                this.logger.debug("could not find primary group for SID {}", (Object)groupSid);
            } else {
                LdapAttribute memberOf = entry.getAttribute("memberOf");
                if (memberOf == null) {
                    memberOf = new LdapAttribute("memberOf");
                    entry.addAttribute(memberOf);
                }
                memberOf.addStringValue(result.getEntry().getDn());
            }
        }
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(1831, this.groupFilter, this.baseDn);
    }
}

