/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.ldaptive.control.RequestControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationHandler
implements AuthenticationHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RequestControl[] authenticationControls;

    public RequestControl[] getAuthenticationControls() {
        return this.authenticationControls;
    }

    public void setAuthenticationControls(RequestControl ... c) {
        this.authenticationControls = c;
    }

    @Override
    public AuthenticationHandlerResponse authenticate(AuthenticationCriteria ac) throws LdapException {
        this.logger.debug("authenticate criteria={}", (Object)ac);
        AuthenticationHandlerResponse response = null;
        Connection conn = this.getConnection();
        boolean closeConn = false;
        try {
            response = this.authenticateInternal(conn, ac);
        }
        catch (LdapException e) {
            closeConn = true;
            throw e;
        }
        catch (RuntimeException e) {
            closeConn = true;
            throw e;
        }
        finally {
            if (closeConn) {
                conn.close();
            }
        }
        this.logger.debug("authenticate response={} for criteria={}", (Object)response, (Object)ac);
        return response;
    }

    protected abstract Connection getConnection() throws LdapException;

    protected abstract AuthenticationHandlerResponse authenticateInternal(Connection var1, AuthenticationCriteria var2) throws LdapException;
}

