/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.Credential;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.EntryResolver;
import org.ldaptive.auth.NoOpEntryResolver;
import org.ldaptive.auth.SearchEntryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authenticator {
    private static final EntryResolver NOOP_RESOLVER = new NoOpEntryResolver();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DnResolver dnResolver;
    private AuthenticationHandler authenticationHandler;
    private EntryResolver entryResolver;
    private AuthenticationResponseHandler[] authenticationResponseHandlers;
    private boolean resolveEntryOnFailure;

    public Authenticator() {
    }

    public Authenticator(DnResolver resolver, AuthenticationHandler handler) {
        this.setDnResolver(resolver);
        this.setAuthenticationHandler(handler);
    }

    public DnResolver getDnResolver() {
        return this.dnResolver;
    }

    public void setDnResolver(DnResolver resolver) {
        this.dnResolver = resolver;
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public void setAuthenticationHandler(AuthenticationHandler handler) {
        this.authenticationHandler = handler;
    }

    public EntryResolver getEntryResolver() {
        return this.entryResolver;
    }

    public void setEntryResolver(EntryResolver resolver) {
        this.entryResolver = resolver;
    }

    public boolean getResolveEntryOnFailure() {
        return this.resolveEntryOnFailure;
    }

    public void setResolveEntryOnFailure(boolean b) {
        this.resolveEntryOnFailure = b;
    }

    public AuthenticationResponseHandler[] getAuthenticationResponseHandlers() {
        return this.authenticationResponseHandlers;
    }

    public void setAuthenticationResponseHandlers(AuthenticationResponseHandler ... handlers) {
        this.authenticationResponseHandlers = handlers;
    }

    public String resolveDn(String user) throws LdapException {
        return this.dnResolver.resolve(user);
    }

    public AuthenticationResponse authenticate(AuthenticationRequest request) throws LdapException {
        return this.authenticate(this.resolveDn(request.getUser()), request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationResponse authenticate(String dn, AuthenticationRequest request) throws LdapException {
        this.logger.debug("authenticate dn={} with request={}", (Object)dn, (Object)request);
        AuthenticationResponse invalidInput = this.validateInput(dn, request);
        if (invalidInput != null) {
            return invalidInput;
        }
        LdapEntry entry = null;
        AuthenticationHandlerResponse response = null;
        try {
            AuthenticationCriteria ac = new AuthenticationCriteria(dn, request);
            response = this.getAuthenticationHandler().authenticate(ac);
            entry = this.resolveEntry(request, response, ac);
        }
        finally {
            if (response != null && response.getConnection() != null) {
                response.getConnection().close();
            }
        }
        this.logger.info("Authentication {} for dn: {}", (Object)((Boolean)response.getResult() != false ? "succeeded" : "failed"), (Object)dn);
        AuthenticationResponse authResponse = new AuthenticationResponse((Boolean)response.getResult() != false ? AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS : AuthenticationResultCode.AUTHENTICATION_HANDLER_FAILURE, response.getResultCode(), entry, response.getMessage(), response.getControls(), response.getMessageId());
        if (this.getAuthenticationResponseHandlers() != null && this.getAuthenticationResponseHandlers().length > 0) {
            for (AuthenticationResponseHandler ah : this.getAuthenticationResponseHandlers()) {
                ah.handle(authResponse);
            }
        }
        this.logger.debug("authenticate response={} for dn={} with request={}", new Object[]{response, dn, request});
        return authResponse;
    }

    protected AuthenticationResponse validateInput(String dn, AuthenticationRequest request) {
        AuthenticationResponse response = null;
        Credential credential = request.getCredential();
        if (credential == null || credential.getBytes() == null) {
            response = new AuthenticationResponse(AuthenticationResultCode.INVALID_CREDENTIAL, null, null, "Credential cannot be null", null, -1);
        } else if (credential.getBytes().length == 0) {
            response = new AuthenticationResponse(AuthenticationResultCode.INVALID_CREDENTIAL, null, null, "Credential cannot be empty", null, -1);
        } else if (dn == null) {
            response = new AuthenticationResponse(AuthenticationResultCode.DN_RESOLUTION_FAILURE, null, null, "DN cannot be null", null, -1);
        } else if (dn.isEmpty()) {
            response = new AuthenticationResponse(AuthenticationResultCode.DN_RESOLUTION_FAILURE, null, null, "DN cannot be empty", null, -1);
        }
        return response;
    }

    protected LdapEntry resolveEntry(AuthenticationRequest request, AuthenticationHandlerResponse response, AuthenticationCriteria criteria) throws LdapException {
        LdapEntry entry = null;
        if (this.resolveEntryOnFailure || ((Boolean)response.getResult()).booleanValue()) {
            EntryResolver er = this.entryResolver != null ? this.entryResolver : (!ReturnAttributes.NONE.equalsAttributes(request.getReturnAttributes()) ? new SearchEntryResolver() : NOOP_RESOLVER);
            try {
                entry = er.resolve(response.getConnection(), criteria);
                this.logger.trace("resolved entry={} with resolver={}", (Object)entry, (Object)er);
            }
            catch (LdapException e) {
                this.logger.debug("entry resolution failed for resolver={}", (Object)er, (Object)e);
            }
        }
        if (entry == null) {
            entry = NOOP_RESOLVER.resolve(response.getConnection(), criteria);
            this.logger.trace("resolved entry={} with resolver={}", (Object)entry, (Object)NOOP_RESOLVER);
        }
        return entry;
    }

    public String toString() {
        return String.format("[%s@%d::dnResolver=%s, authenticationHandler=%s, entryResolver=%s, authenticationResponseHandlers=%s]", this.getClass().getName(), this.hashCode(), this.getDnResolver(), this.getAuthenticationHandler(), this.getEntryResolver(), Arrays.toString(this.getAuthenticationResponseHandlers()));
    }
}

