/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionFactoryManager;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.auth.AbstractBindAuthenticationHandler;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandlerResponse;

public class BindAuthenticationHandler
extends AbstractBindAuthenticationHandler
implements ConnectionFactoryManager {
    private ConnectionFactory factory;

    public BindAuthenticationHandler() {
    }

    public BindAuthenticationHandler(ConnectionFactory cf) {
        this.setConnectionFactory(cf);
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionFactory(ConnectionFactory cf) {
        this.factory = cf;
    }

    @Override
    protected Connection getConnection() throws LdapException {
        return this.factory.getConnection();
    }

    @Override
    protected AuthenticationHandlerResponse authenticateInternal(Connection c, AuthenticationCriteria criteria) throws LdapException {
        AuthenticationHandlerResponse response;
        BindRequest request = new BindRequest(criteria.getDn(), criteria.getCredential());
        request.setSaslConfig(this.getAuthenticationSaslConfig());
        request.setControls(this.getAuthenticationControls());
        try {
            Response<Void> connResponse = c.open(request);
            response = new AuthenticationHandlerResponse(ResultCode.SUCCESS == connResponse.getResultCode(), connResponse.getResultCode(), c, connResponse.getMessage(), connResponse.getControls(), connResponse.getMessageId());
        }
        catch (LdapException e) {
            if (e.getResultCode() != null) {
                response = new AuthenticationHandlerResponse(false, e.getResultCode(), c, e.getMessage(), e.getControls(), e.getMessageId());
            }
            throw e;
        }
        return response;
    }

    public String toString() {
        return String.format("[%s@%d::factory=%s, saslConfig=%s, controls=%s]", this.getClass().getName(), this.hashCode(), this.factory, this.getAuthenticationSaslConfig(), Arrays.toString(this.getAuthenticationControls()));
    }
}

