/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.BindOperation;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.auth.AbstractBindAuthenticationHandler;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.PooledConnectionFactoryManager;

public class PooledBindAuthenticationHandler
extends AbstractBindAuthenticationHandler
implements PooledConnectionFactoryManager {
    private PooledConnectionFactory factory;

    public PooledBindAuthenticationHandler() {
    }

    public PooledBindAuthenticationHandler(PooledConnectionFactory cf) {
        this.setConnectionFactory(cf);
    }

    @Override
    public PooledConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionFactory(PooledConnectionFactory cf) {
        this.factory = cf;
    }

    @Override
    protected Connection getConnection() throws LdapException {
        return this.factory.getConnection();
    }

    @Override
    protected AuthenticationHandlerResponse authenticateInternal(Connection c, AuthenticationCriteria criteria) throws LdapException {
        AuthenticationHandlerResponse response;
        BindRequest request = new BindRequest(criteria.getDn(), criteria.getCredential());
        request.setSaslConfig(this.getAuthenticationSaslConfig());
        request.setControls(this.getAuthenticationControls());
        BindOperation op = new BindOperation(c);
        try {
            Response bindResponse = op.execute(request);
            response = new AuthenticationHandlerResponse(ResultCode.SUCCESS == bindResponse.getResultCode(), bindResponse.getResultCode(), c, bindResponse.getMessage(), bindResponse.getControls(), bindResponse.getMessageId());
        }
        catch (LdapException e) {
            if (e.getResultCode() != null) {
                response = new AuthenticationHandlerResponse(false, e.getResultCode(), c, e.getMessage(), e.getControls(), e.getMessageId());
            }
            throw e;
        }
        return response;
    }

    public String toString() {
        return String.format("[%s@%d::factory=%s, saslConfig=%s, controls=%s]", this.getClass().getName(), this.hashCode(), this.factory, this.getAuthenticationSaslConfig(), Arrays.toString(this.getAuthenticationControls()));
    }
}

