/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth.ext;

import java.util.Calendar;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.ad.io.FileTimeValueTranscoder;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.ext.ActiveDirectoryAccountState;

public class ActiveDirectoryAuthenticationResponseHandler
implements AuthenticationResponseHandler {
    private long maxPasswordAge = -1L;

    public ActiveDirectoryAuthenticationResponseHandler() {
    }

    public ActiveDirectoryAuthenticationResponseHandler(long passwordAge) {
        if (passwordAge < 0L) {
            throw new IllegalArgumentException("Password age must be >= 0");
        }
        this.maxPasswordAge = passwordAge;
    }

    @Override
    public void handle(AuthenticationResponse response) {
        ActiveDirectoryAccountState.Error adError;
        if (((Boolean)response.getResult()).booleanValue()) {
            LdapEntry entry;
            LdapAttribute pwdLastSet;
            if (this.maxPasswordAge >= 0L && (pwdLastSet = (entry = response.getLdapEntry()).getAttribute("pwdLastSet")) != null) {
                Calendar exp = pwdLastSet.getValue(new FileTimeValueTranscoder());
                exp.setTimeInMillis(exp.getTimeInMillis() + this.maxPasswordAge);
                response.setAccountState(new ActiveDirectoryAccountState(exp));
            }
        } else if (response.getMessage() != null && (adError = ActiveDirectoryAccountState.Error.parse(response.getMessage())) != null) {
            response.setAccountState(new ActiveDirectoryAccountState(adError));
        }
    }
}

